% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LmME.R
\name{confint.LmME}
\alias{confint.LmME}
\title{Confidence intervals for LmME model parameters}
\usage{
\method{confint}{LmME}(
  object,
  parm = NULL,
  level = 0.95,
  as.lm = FALSE,
  pargroup = c("all", "fixef", "shift", "baseline", "ranef"),
  type = c("Wald", "wald", "profile"),
  estimate = FALSE,
  pmatch = FALSE,
  ...
)
}
\arguments{
\item{object}{An \code{LmME} object.}

\item{parm}{The indeces or names of the parameters of interest. See in details.}

\item{level}{Confidence level.}

\item{as.lm}{Logical. If \code{TRUE}, return results consistent with the normal linear
mixed model parametrization.}

\item{pargroup}{fixef: fixed-effects, shift: shift parameters, all: fixed
effects and variance component parameters, baseline: parameters of the
baseline transformation function, ranef: variance components parameters.}

\item{type}{Type of the CI: either Wald or profile.}

\item{estimate}{Logical, add the point estimates in a thrid column.}

\item{pmatch}{Logical. If \code{TRUE}, partial name matching is allowed.}

\item{...}{Optional parameters passed to \code{confint.tramME}}
}
\value{
A matrix with lower and upper bounds.
}
\description{
Confidence intervals for model parameters on their original scale,
optionally consistent with the linear mixed-model specification.
When \code{as.lm = TRUE}, only Wald CIs are available.
}
\examples{
data("sleepstudy", package = "lme4")
fit <- LmME(Reaction ~ Days + (Days | Subject), data = sleepstudy)
confint(fit) ## transformation model parametrization
confint(fit, as.lm = TRUE) ## LMM parametrization
confint(fit, as.lm = TRUE, pargroup = "fixef", estimate = TRUE)
confint(fit, as.lm = TRUE, parm = "(Sigma)") ## error SD
}
