% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{TrajSplitAtFirstCrossing}
\alias{TrajSplitAtFirstCrossing}
\title{Split a trajectory into two parts, separated at the first boundary crossing}
\usage{
TrajSplitAtFirstCrossing(trj, boundary)
}
\arguments{
\item{trj}{The trajectory to split.}

\item{boundary}{A polygon defining the boundary.  Can be any structure that
\code{\link{xy.coords}} can handle, such as a data frame with \code{x} and
\code{y} columns.}
}
\value{
A list with 1 or 2 elements. If \code{trj} lies entirely inside or
  outside \code{boundary}, then the list simply contains \code{trj}. If
  \code{trj} crosses the boundary, then the list contains 2 trajectories. The
  first is the longest part of \code{trj} that lies entirely inside or
  outside \code{boundary}, and the second is the remainder of \code{trj}.
}
\description{
This is basically a wrapper around \code{\link{TrajInPolygon}} and
\code{\link{TrajSplit}}.
}
\examples{
# Square arena
boundary <- data.frame(x = c(-10, 10, 10, -10), y = c(-10, -10, 10, 10))

# Generate a random trajectory
set.seed(1)
trj <- TrajGenerate(n = 8, stepLength = 3, angularErrorSd = .4)
# Split the trajectory where it crosses the boundary
l <- TrajSplitAtFirstCrossing(trj, boundary)

# Plot the boundary and the two trajectories
plot(NULL, xlim = range(c(boundary$x, trj$x)), ylim = range(c(boundary$y, trj$y)), asp = 1)
polygon(boundary, border = "brown", lwd = 2)
lines(l[[1]], col = "#2040ff80", lwd = 3)
lines(l[[2]], col = "#ff204080", lwd = 3)

}
\seealso{
\code{\link{TrajInPolygon}}, \code{\link{TrajSplit}}
}
