% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/speed.R
\name{TrajDerivatives}
\alias{TrajDerivatives}
\title{Calculates trajectory speed and acceleration}
\usage{
TrajDerivatives(trj)
}
\arguments{
\item{trj}{Trajectory whose speed and acceleration is to be calculated.}
}
\value{
A list with components: \item{speed}{numeric vector, speed between
  each pair of trajectory points.} \item{speedTimes}{numeric vector, times
  corresponding to values in \code{speed}.} \item{acceleration}{numeric
  vector.} \item{accelerationTimes}{numeric vector.}
}
\description{
Calculates speed and linear acceleration along a trajectory over time. Noisy
trajectories should be smoothed before being passed to this function, as
noise is effectively amplifed when calculating speed and acceleration.
}
\seealso{
\code{\link{TrajSpeedIntervals}} for analysing intervals within the
  trajectory of low or high speed. \code{\link{TrajSmoothSG}} for smoothing a
  trajectory.
}
