% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajmsm_pltmle.R
\name{trajmsm_pltmle}
\alias{trajmsm_pltmle}
\title{Pooled LTMLE}
\usage{
trajmsm_pltmle(
  formula = formula,
  identifier,
  baseline,
  covariates,
  treatment,
  outcome,
  number_traj,
  total_followup,
  time,
  time_values,
  trajmodel,
  ref,
  treshold = 0.99,
  class_var,
  obsdata
)
}
\arguments{
\item{formula}{Specification of the model for the outcome to be fitted.}

\item{identifier}{Name of the column for unique identifiant.}

\item{baseline}{Names of the baseline covariates.}

\item{covariates}{Names of the time-varying covariates (should be a list).}

\item{treatment}{Name of the time-varying treatment.}

\item{outcome}{Name of the outcome variable.}

\item{number_traj}{An integer to choose the number of trajectory groups.}

\item{total_followup}{Total length of follow-up.}

\item{time}{Name of the time variable.}

\item{time_values}{Measuring times.}

\item{trajmodel}{Trajectory model built with the observed treatment.}

\item{ref}{The reference group.}

\item{treshold}{For weight truncation.}

\item{class_var}{name of the trajectory group variable.}

\item{obsdata}{Observed data in wide format.}
}
\value{
Provides a matrix of estimates for LCGA-MSM, obtained using the pooled ltlmle method.

\item{results_msm_pooledltmle}{Estimates of a LCGA-MSM with pooled LTMLE.}
}
\description{
Estimate parameters of LCGA-MSM using pooled LTMLE
 with influence functions to estimate standard errors.
}
\examples{
\donttest{
obsdata_long = gendata(n = 1000, format = "long", total_followup = 6, seed = 845)
years <- 2011:2016
baseline_var <- c("age","sex")
variables <- c("hyper", "bmi")
covariates <- lapply(years, function(year) {
paste0(variables, year)})
treatment_var <- paste0("statins", 2011:2016)
formula_treatment = as.formula(cbind(statins, 1 - statins) ~ time)
restraj = build_traj(obsdata = obsdata_long, number_traj = 3,
formula = formula_treatment, identifier = "id")
datapost = restraj$data_post
trajmsm_long <- merge(obsdata_long, datapost, by = "id")
    AggFormula <- as.formula(paste("statins", "~", "time", "+", "class"))
    AggTrajData <- aggregate(AggFormula, data = trajmsm_long, FUN = mean)
trajmsm_wide = reshape(data = trajmsm_long, direction = "wide", idvar = "id",
v.names = c("statins","bmi","hyper"), timevar = "time", sep ="")
formula = paste0("y ~", paste0(treatment_var,collapse = "+"), "+",
                paste0(unlist(covariates), collapse = "+"),"+",
                paste0(baseline_var, collapse = "+"))
resmsm_pltmle <- trajmsm_pltmle(formula = formula, identifier = "id",
 baseline = baseline_var,
 covariates = covariates, treatment = treatment_var,
 outcome = "y", time = "time", time_values = years,
 number_traj = 3, total_followup = 6,
 trajmodel = restraj$traj_model, ref = "1", obsdata = trajmsm_wide,
 class_var = "class", treshold = 1)
 resmsm_pltmle
 }
}
\author{
Awa Diop, Denis Talbot
}
