% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Step1Measures.R
\name{Step1Measures}
\alias{Step1Measures}
\alias{print.trajMeasures}
\alias{summary.trajMeasures}
\title{Compute Measures for Identifying Patterns of Change in Longitudinal
Data}
\usage{
Step1Measures(Data, Time = NULL, ID = FALSE, measures = 1:23, midpoint = NULL)

\method{print}{trajMeasures}(x, ...)

\method{summary}{trajMeasures}(object, ...)
}
\arguments{
\item{Data}{a matrix or data frame in which each row contains the longitudinal
data (trajectories).}

\item{Time}{either NULL, a vector or a matrix/data frame of the same dimension
as \code{Data}. If a vector, matrix or data frame is supplied, its entries
are assumed to be measured at the times of the corresponding cells in
\code{Data}. When set to \code{NULL} (the default), the times are assumed
equidistant.}

\item{ID}{logical. Set to \code{TRUE} if the first columns of \code{Data} and
\code{Time} corresponds to an \code{ID} variable identifying the
trajectories. Defaults to \code{FALSE}.}

\item{measures}{a vector containing the numerical identifiers of the measures
to compute (see "Details" section below). The default, 1:23, corresponds to
measures 1-23 and thus excludes the measures which require specifying a
midpoint.}

\item{midpoint}{specifies which column of \code{Time} to use as the midpoint
in measures 24-26. Can be NULL, an integer or a vector of integers of length
the number of rows in \code{Time}. The default is NULL, in which case the
midpoint is the time closest to the median of the Time vector specific to
each trajectory.}

\item{x}{object of class trajMeasures.}

\item{...}{further arguments passed to or from other methods.}

\item{object}{object of class trajMeasures.}
}
\value{
An object of class \code{trajMeasures}; a list containing the values
of the measures, a table of the outliers which have been capped, as well as
a curated form of the function's arguments.
}
\description{
\code{Step1Measures} computes up to 26 measures for each
longitudinal trajectory. See Details for the list of measures.
}
\details{
Each trajectory must have a minimum of 3 observations otherwise it
will be omitted from the analysis.

The 26 measures and their numerical identifiers are listed below. Please
refer to the vignette for the specific formulas used to compute them.
\enumerate{
\item  Range\cr
\item  Mean of the function\cr
\item  Functional standard deviation (SD)\cr
\item  Coefficient of variation (ratio of measure 3 to measure 2)\cr
\item  Overall change (initial value - final value)\cr
\item  Mean change per unit time\cr
\item  Overall change relative to initial value\cr
\item  Overall change relative to functional mean (ratio of measure 5 to measure 2)\cr
\item  Slope of the linear model\cr
\item  \eqn{R^2}: Proportion of variance explained by the linear model\cr
\item  Maximum value of the speed\cr
\item  Functional SD of the speed\cr
\item  Mean absolute speed\cr
\item  Maximum absolute speed\cr
\item  Maximum absolute speed relative to the functional mean (ratio of measure 14 to measure 2)\cr
\item  Maximum absolute speed relative to the slope (ratio of measure 14 to measure 9)\cr
\item  Functional SD of the speed relative to the slope\cr(ratio of measure 12 to measure 9)
\item  Mean acceleration\cr
\item  Mean absolute acceleration\cr
\item  Maximum of the absolute acceleration\cr
\item  Maximum of the absolute acceleration relative to the functional (ratio of measure 20 to measure 2)\cr
\item  Maximum of the absolute acceleration relative to the mean absolute speed (ratio of measure 20 to measure 13)\cr
\item  Mean absolute acceleration relative to the mean absolute speed (ratio of measure 19 to measure 13)\cr
\item  Early change relative to later change\cr
\item  Early change relative to overall change\cr
\item  Later change relative to overall change\cr
}
}
\examples{
\dontrun{
m1 = Step1Measures(trajdata, ID = TRUE, measures = 24:26, midpoint = NULL)
m2 = Step1Measures(trajdata, ID = TRUE, measures = 24:26, midpoint = 3)

identical(s1$measures, s2$measures)
}

}
\references{
Leffondre K, Abrahamowicz M, Regeasse A, Hawker GA, Badley EM,
McCusker J, Belzile E. Statistical measures were proposed for identifying
longitudinal patterns of change in quantitative health indicators. J Clin
Epidemiol. 2004 Oct;57(10):1049-62. doi: 10.1016/j.jclinepi.2004.02.012.
PMID: 15528056.

Nishiyama T, Improved Chebyshev inequality: new probability bounds with
known supremum of PDF, arXiv:1808.10770v2 stat.ME
https://doi.org/10.48550/arXiv.1808.10770
}
