% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{carabids}
\alias{carabids}
\title{Carabid morphological traits}
\format{
A data frame containing following columns:
\itemize{
\item name_correct = species name
\item source_measurement = researcher who performed measurement;
\item body_length = body length in mm;
\item antenna_length = antenna length in mm;
\item metafemur_length = length metafemur in mm;
\item eyewidth_corr = eye width in mm;
\item note = note;
\item resid_femur = residual femur length in mm (i.e. residual from
linear model in which femur length is explained by body length);
\item resid_eye = residual eye length in mm (i.e. residual from linear
model in which eye length is explained by body length)
\item resid_antenna = residual antenna length in mm (i.e. residual
from linear model in which antenna length is explained by body length)
}
}
\source{
\doi{10.5061/dryad.53ds2};
\href{https://creativecommons.org/publicdomain/zero/1.0/}{Creative Commons
0}. To the extent possible under law, the authors have waived all copyright
and related or neighboring rights to this data.
}
\value{
This is a data object. provides instructions for \code{pulldata()}.
}
\description{
Average body measures of 120 Carabid species occuring in the Netherlands.
}
\details{
When using this data, please cite the original publication:

\itemize{ \item  van der Plas F, van Klink R, Manning P, Olff H, Fischer M
(2017) Sensitivity of functional diversity metrics to sampling intensity.
Methods in Ecology and Evolution 8(9): 1072-1080.
doi: \doi{10.1111/2041-210x.12728} }

Additionally, please cite the Dryad data package:

\itemize{ \item van der Plas F, van Klink R, Manning P, Olff H, Fischer M
(2017) Data from: Sensitivity of functional diversity metrics to sampling
intensity. Dryad Digital Repository. doi: \doi{10.5061/dryad.1fn46} }
}
\seealso{
Other rawdata: 
\code{\link{amniota}},
\code{\link{amphibio}},
\code{\link{arthropodtraits}},
\code{\link{heteroptera_raw}},
\code{\link{mammaldiet}},
\code{\link{pantheria}},
\code{\link{pulldata}()}
}
\author{
Fons van der Plas, R. van Klink, P. Manning, H. Olff, M. Fischer
}
\concept{rawdata}
