% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ots_inflation_adjustment.R
\name{ots_inflation_adjustment}
\alias{ots_inflation_adjustment}
\title{Expresses tidy data from the API in dollars of a reference year}
\usage{
ots_inflation_adjustment(trade_data = NULL, reference_year = NULL)
}
\arguments{
\item{trade_data}{A tibble obtained by using ots_create_tidy_data.
Default set to \code{NULL}.}

\item{reference_year}{Year contained within the years specified in
api.tradestatistics.io/year_range (e.g. \code{2010}).
Default set to \code{NULL}.}
}
\description{
Uses inflation records from The World Bank to
convert trade records and express them in dollars of the same year.
}
\examples{
\dontrun{
# The next example can take more than 5 seconds to compute,
# so this is shown without evaluation according to CRAN rules

# Convert dollars of 2010 to dollars of 2000
d <- ots_create_tidy_data(years = 2010, reporters = "chl", partners = "chn")
ots_inflation_adjustment(trade_data = d, reference_year = 2000)
}
}
\keyword{functions}
