% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monopolistic_competition_tariff.R
\name{monopolistic_competition_tariff}
\alias{monopolistic_competition_tariff}
\title{Tariff Simulation With A Monopolistic Competition Pricing Game}
\usage{
monopolistic_competition_tariff(
  demand = c("logit", "ces"),
  prices,
  quantities,
  margins,
  mktElast = NA_real_,
  mktSize,
  tariffPre = rep(0, length(quantities)),
  tariffPost = rep(0, length(quantities)),
  priceOutside = ifelse(demand == "logit", 0, 1),
  labels = paste("Prod", 1:length(quantities), sep = "")
)
}
\arguments{
\item{demand}{A character vector indicating which demand system to use. Currently allows ``logit" or ``ces" .}

\item{prices}{A length k vector product prices. Default is missing, in which case demand intercepts are not calibrated.}

\item{quantities}{A length k vector of product quantities.}

\item{margins}{A length k vector of product margins. All margins must be either be between 0 and 1, or NA.}

\item{mktElast}{A negative number equal to the industry pre-tariff price elasticity. Default is NA .}

\item{mktSize}{A positive number equal to the industry pre-tariff market size. Market size equals total quantity sold,\emph{including sales to the outside good}.}

\item{tariffPre}{A vector of length k where each element equals the \strong{current} \emph{ad valorem} tariff
(expressed as a proportion of the consumer price) imposed on each product. Default is 0, which assumes no tariff.}

\item{tariffPost}{A vector of length k where each element equals the \strong{new}  \emph{ad valorem} tariff
(expressed as a proportion of the consumer price) imposed on each product. Default is 0, which assumes no tariff.}

\item{priceOutside}{price of the outside good. Default 0 for logit and 1 for ces. Not used for aids.}

\item{labels}{A k-length vector of labels.}
}
\value{
\code{monopolistic_competition_tariff} returns an instance of class \code{\linkS4class{TariffMonComLogit}} , depending upon the value of the ``demand'' argument.
}
\description{
Simulate the effect of tariffs when firms play a Monopolistic Competition game and consumer demand is either Logit or CES
}
\details{
Let k denote the number of products produced by all firms.
Using price, and quantity, information for all products
in each market, as well as margin information for at least
one products in each market, \code{monopolistic_competition_tariff} is able to
recover the slopes and intercepts of a Logit demand
system. These parameters are then used to simulate the price
effects of an \emph{ad valorem} tariff under the assumption that the firms are playing a monopolisitcally competitive pricing game
}
\examples{
## Calibration and simulation results from a 10\% tariff on non-US beers "OTHER-LITE"
## and "OTHER-REG"
## Source: Epstein/Rubenfeld 2004, pg 80

prodNames <- c("BUD","OLD STYLE","MILLER","MILLER-LITE","OTHER-LITE","OTHER-REG")
price    <- c(.0441,.0328,.0409,.0396,.0387,.0497)
quantities   <- c(.066,.172,.253,.187,.099,.223)*100
margins <- c(.3830,.5515,.5421,.5557,.4453,.3769)
tariff <- c(0,0,0,0,.1,.1)

names(price) <-
 names(quantities) <-
 names(margins) <-
 prodNames


result.logit <- monopolistic_competition_tariff(demand = "logit",prices=price,quantities=quantities,
                                margins = margins,
                                 tariffPost = tariff, labels=prodNames)

print(result.logit)           # return predicted price change
summary(result.logit)         # summarize merger simulation

result.ces <- monopolistic_competition_tariff(demand = "ces",prices=price,quantities=quantities,
                                margins = margins,
                                 tariffPost = tariff, labels=prodNames)

print(result.ces)           # return predicted price change
summary(result.ces)         # summarize merger simulation

}
\references{
Simon P. Anderson, Andre de Palma, Brent Kreider, Tax incidence in differentiated product oligopoly,
Journal of Public Economics, Volume 81, Issue 2, 2001, Pages 173-192.
Anderson, Simon P., and André De Palma. Economic distributions and primitive distributions in monopolistic competition. Centre for Economic Policy Research, 2015.
}
\seealso{
\code{\link{bertrand_tariff}} to simulate the effects of a tariff under a Bertrand pricing game.
}
