% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dicom_dir.R
\name{sortDicomDirectories}
\alias{sortDicomDirectories}
\title{Sort a directory of DICOM files into series}
\usage{
sortDicomDirectories(directories, method = c("internal", "divest"),
  deleteOriginals = FALSE, sortOn = "series", seriesId = c("UID",
  "number", "time"), nested = TRUE, ...)
}
\arguments{
\item{directories}{A character vector giving the directories to search for
DICOM files. Subdirectories will also be searched.}

\item{method}{Character string specifying whether to use the internal DICOM
reading code or use the \code{divest} package.}

\item{deleteOriginals}{A single logical value. If \code{TRUE}, then the
source files will be deleted after being copied to their new locations,
making the operation a move rather than a copy. Nothing will be deleted if
the copy fails.}

\item{sortOn}{The string \code{"series"}, \code{"subject"} or \code{"date"},
or any combination in the order desired. This will be the basis of the
sort, which will be nested if more than one type is specified.}

\item{seriesId}{A string describing the kind of series identifier to use for
sorting by series: \code{"UID"} (DICOM tag 0x0020,0x000e; the default),
\code{"number"} (0x0020,0x0011) or \code{"time"} (0x0008,0x0031).}

\item{nested}{Logical value. If \code{TRUE} and \code{directories} is of
length 1, subdirectories will be created within the specified original
directory. Otherwise they will be created in the working directory.}

\item{...}{Additional arguments to pass to \code{\link{readDicomFile}}.}
}
\value{
This function is called for its side effect.
}
\description{
This function sorts a directory containing DICOM files into subdirectories
by series UID (DICOM tag 0x0020,0x000e), subject name (0x0010,0x0010) and/or
scan date (0x0008,0x0020). Each unique identifier, together with its
description for series, will be used as the name for a new subdirectory, and
all relevant files will be copied into that subdirectory. Duplicate file
names are disambiguated if necessary.
}
\references{
Please cite the following reference when using TractoR in your
work:

J.D. Clayden, S. Muñoz Maniega, A.J. Storkey, M.D. King, M.E. Bastin & C.A.
Clark (2011). TractoR: Magnetic resonance imaging and tractography with R.
Journal of Statistical Software 44(8):1-18.
\url{http://www.jstatsoft.org/v44/i08/}.
}
\seealso{
\code{\link{readDicomDirectory}} for reading DICOM files into an
\code{MriImage} object.
}
\author{
Jon Clayden
}
