% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/15_dicom.R
\docType{class}
\name{DicomMetadata-class}
\alias{DicomMetadata-class}
\alias{DicomMetadata}
\title{The DicomMetadata class}
\description{
This class represents DICOM metadata, which typically contains detailed
information about the scan parameters and subject.
}
\section{Fields}{

\describe{
\item{\code{source}}{String naming the source file}

\item{\code{tags}}{Data frame of tag information}

\item{\code{tagOffset}}{Starting offset for tags in the file}

\item{\code{dataOffset}}{Starting offset for pixel data in the file}

\item{\code{dataLength}}{Pixel data length}

\item{\code{explicitTypes}}{Logical value indicating whether explicit types are
used in the file}

\item{\code{endian}}{String naming the endianness of the file}

\item{\code{asciiFields}}{Character vector containing the contents of the ASCII
header, if requested and present in the file.}
}}

\section{Methods}{

\describe{
\item{\code{getAsciiFields(regex = NULL)}}{Retrieve the value of one or more fields in the ASCII header. Returns NA if no fields match}

\item{\code{getTagValue(group, element)}}{Retrieve the value of a given tag, using an appropriate R type. Returns NA if the tag is missing}
}}

