% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ffmpeg.R
\name{vid.to.images}
\alias{vid.to.images}
\title{Extracts images from a video file with ffmpeg}
\usage{
vid.to.images(vid.path = NULL, out.dir = NULL, overwrite = FALSE,
  qual = 50)
}
\arguments{
\item{vid.path}{Character; path of video file to be processed.}

\item{out.dir}{character; directory path in which to store images.}

\item{overwrite}{logical; should path described by 'out.dir' be overwritten if it exhists.}

\item{qual}{numeric; the quality of the jpeg images to be rendered from 1-100\%. Defaults to 50\%.}
}
\value{
Extracts all the images of the video and saves them to an "images" directory with appended number sequence
}
\description{
Uses ffmpeg systems calls to extract images from a video.
}
\examples{

#make a video with animation package
\donttest{
require(animation)
fun <- function(){
y <- sin(1:50)
x <- 1:50
for(i in 1:50) {
  plot(x[i],y[i],col="red",xlim=c(0,50),ylim=range(y))
  animation::ani.pause()
  }
}
animation::saveVideo(fun(),video.name=paste0(tempdir(),"/wave.mp4"),interval = 0.2)

#create directory in which to store images
dir.create(paste0(tempdir(),"/images"))
vid.to.images(vid.path=paste0(tempdir(),"/wave.mp4"),
out.dir= paste0(tempdir(),"/images"),qual=100)

#see the images in the "images" subdirectory
list.files( paste0(tempdir(),"/images"))
}
}
\seealso{
\code{\link{images.to.video}}
}
