% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributionProfile.R
\name{plot.distrProfile}
\alias{plot.distrProfile}
\title{Plot distribution profiles.}
\usage{
\method{plot}{distrProfile}(x, session = NULL, what = NULL, multiple = FALSE, smooth = FALSE, ...)
}
\arguments{
\item{x}{An object of class \code{distrProfile} as returned by
\code{\link{distribution_profile}}.}

\item{session}{A numeric vector of the sessions to be plotted,
defaults to all sessions.}

\item{what}{Which variables should be plotted? Defaults to all
variables in \code{object} (\code{what = NULL}).}

\item{multiple}{Logical. Should all sessions be plotted in one
panel?}

\item{smooth}{Logical. Should unsmoothed profiles be smoothed
before plotting?}

\item{...}{Further arguments to be passed to
\code{\link{smoother_control.distrProfile}}.}
}
\description{
Plot distribution profiles.
}
\examples{
\dontrun{
data('runs', package = 'trackeR')
dProfile <- distribution_profile(runs, session = 1:2,
    what = "speed", grid = seq(0, 12.5, by = 0.05))
plot(dProfile, smooth = FALSE)
plot(dProfile, smooth = FALSE, multiple = TRUE)
plot(dProfile, multiple = TRUE)
}
}
