% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcPCA.R
\name{plot.trackeRfpca}
\alias{plot.trackeRfpca}
\title{Plot function for functional principal components analysis of distribution and concentration profiles.}
\usage{
\method{plot}{trackeRfpca}(x, harm = NULL, expand = NULL,
  pointplot = TRUE, ...)
}
\arguments{
\item{x}{An object of class \code{trackeRfpca} as returned by \code{\link{funPCA}}.}

\item{harm}{A numerical vector of the harmonics to be plotted. Defaults to all harmonics.}

\item{expand}{The factor used to generate suitable multiples of the harmonics.
If \code{NULL}, the effect of +/- 2 standard deviations of each harmonic is plotted.}

\item{pointplot}{Should the harmonics be plotted with \code{+} and \code{-}
point characters? Otherwise, lines are used.}

\item{...}{Currently not used.}
}
\description{
Plot function for functional principal components analysis of distribution and concentration profiles.
}
\examples{
data("runs", package = "trackeR")
dp <- distributionProfile(runs, what = "speed")
dp.pca <- funPCA(dp, what = "speed", nharm = 4)
## 1st harmonic  captures vast majority of the variation
plot(dp.pca)
plot(dp.pca, harm = 1, pointplot = FALSE)
}
\references{
Ramsay JO, Silverman BW (2005). Functional Data Analysis. Springer-Verlag New York.
}
\seealso{
\code{\link[fda]{plot.pca.fd}}
}
