% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_census_and_acs.R
\name{search_tables}
\alias{search_tables}
\title{Search Tables}
\usage{
search_tables(survey, years = NULL, keywords = NULL, view = TRUE)
}
\arguments{
\item{survey}{survey type, including "dec" (or "decennial"), "acs1" or "acs5".}

\item{years}{year or ending year of the survey, can be a single year such as
2010 or a vector like 2014:2016.}

\item{keywords}{keyword to search in code or description, in the form like
"abc def dsdfsa". Rows with all words are returned.}

\item{view}{display the search result with View if TRUE}
}
\value{
A data.table
}
\description{
Search table numbers and description.
}
\examples{
# Change view = TRUE (default) to View the returned data.
aaa <- search_tables("dec", 2010, "occupancy", view = FALSE)
bbb <- search_tables("acs5", 2014:2016, "detailed race", view = FALSE)

\dontrun{
  # view all tables
  search_tables("dec")
  search_tables("acs1")
}


}
