# lookup_acs5year_2017 =========================================================
#' ACS 5-year 2017 file segment and table lookup data
#'
#' @docType data
#'
#' @format A data.table with 25070 rows and 7 variables
#' \describe{
#'   \item{file_segment}{sequence number of segment data files, from "0001" to "0122"}
#'   \item{table_content}{description of columns in a table}
#'   \item{reference}{reference of the table content, such as "B01001_002". The reference
#'         is used to extract data of table content.}
#'   \item{restriction}{restrictions applied the the table_content}
#'   \item{table_number}{table number such as "B01001"}
#'   \item{table_name}{description of table. A table has multiple columns (table_content)}
#'   \item{universe}{the universe of the data}
#' }
#'
#' @keywords datasets
#'
#' @source Check for each year of ACS 1-year and 5-year
#' \href{https://www.census.gov/programs-surveys/acs/technical-documentation/summary-file-documentation.2015.html}{Sequence Number/Table Number Lookup File}.
#'

"lookup_acs5year_2017"




# lookup_acs5year_2016 =========================================================
#' ACS 5-year 2016 file segment and table lookup data
#'
#' @docType data
#'
#' @format A data.table with 22958 rows and 7 variables
#' \describe{
#'   \item{file_segment}{sequence number of segment data files, from "0001" to "0122"}
#'   \item{table_content}{description of columns in a table}
#'   \item{reference}{reference of the table content, such as "B01001_002". The reference
#'         is used to extract data of table content.}
#'   \item{restriction}{restrictions applied the the table_content}
#'   \item{table_number}{table number such as "B01001"}
#'   \item{table_name}{description of table. A table has multiple columns (table_content)}
#'   \item{universe}{the universe of the data}
#' }
#'
#' @keywords datasets
#'
#' @source Check for each year of ACS 1-year and 5-year
#' \href{https://www.census.gov/programs-surveys/acs/technical-documentation/summary-file-documentation.2015.html}{Sequence Number/Table Number Lookup File}.
#'

"lookup_acs5year_2016"




# lookup_acs5year_2015 =========================================================
#' ACS 5-year 2015 file segment and table lookup data
#'
#' @docType data
#'
#' @format A data.table with 22910 rows and 7 variables
#' \describe{
#'   \item{file_segment}{sequence number of segment data files, from "0001" to "0122"}
#'   \item{table_content}{description of columns in a table}
#'   \item{reference}{reference of the table content, such as "B01001_002". The reference
#'         is used to extract data of table content.}
#'   \item{restriction}{restrictions applied the the table_content}
#'   \item{table_number}{table number such as "B01001"}
#'   \item{table_name}{description of table. A table has multiple columns (table_content)}
#'   \item{universe}{the universe of the data}
#' }
#'
#' @keywords datasets
#'
#' @source Check for each year of ACS 1-year and 5-year
#' \href{https://www.census.gov/programs-surveys/acs/technical-documentation/summary-file-documentation.2015.html}{Sequence Number/Table Number Lookup File}.
#'

"lookup_acs5year_2015"


# lookup_acs5year_2014 =========================================================
#' ACS 5-year 2014 file segment and table lookup data
#'
#' @docType data
#'
#' @format A data.table with 22627 rows and 7 variables
#' \describe{
#'   \item{file_segment}{sequence number of segment data files, from "0001" to "0122"}
#'   \item{table_content}{description of columns in a table}
#'   \item{reference}{reference of the table content, such as "B01001_002". The reference
#'         is used to extract data of table content.}
#'   \item{restriction}{restrictions applied the the table_content}
#'   \item{table_number}{table number such as "B01001"}
#'   \item{table_name}{description of table. A table has multiple columns (table_content)}
#'   \item{universe}{the universe of the data}
#' }
#'
#' @keywords datasets
#'
#' @source Check for each year of ACS 1-year and 5-year
#' \href{https://www.census.gov/programs-surveys/acs/technical-documentation/summary-file-documentation.2015.html}{Sequence Number/Table Number Lookup File}.
#'

"lookup_acs5year_2014"



# lookup_acs5year_2013 =========================================================
#' ACS 5-year 2013 file segment and table lookup data
#'
#' @docType data
#'
#' @format A data.table with 22711 rows and 7 variables
#' \describe{
#'   \item{file_segment}{sequence number of segment data files, from "0001" to "0122"}
#'   \item{table_content}{description of columns in a table}
#'   \item{reference}{reference of the table content, such as "B01001_002". The reference
#'         is used to extract data of table content.}
#'   \item{restriction}{restrictions applied the the table_content}
#'   \item{table_number}{table number such as "B01001"}
#'   \item{table_name}{description of table. A table has multiple columns (table_content)}
#'   \item{universe}{the universe of the data}
#' }
#'
#' @keywords datasets
#'
#' @source Check for each year of ACS 1-year and 5-year
#' \href{https://www.census.gov/programs-surveys/acs/technical-documentation/summary-file-documentation.2015.html}{Sequence Number/Table Number Lookup File}.
#'

"lookup_acs5year_2013"



# lookup_acs5year_2012 =========================================================
#' ACS 5-year 2012 file segment and table lookup data
#'
#' @docType data
#'
#' @format A data.table with 22527 rows and 7 variables
#' \describe{
#'   \item{file_segment}{sequence number of segment data files, from "0001" to "0122"}
#'   \item{table_content}{description of columns in a table}
#'   \item{reference}{reference of the table content, such as "B01001_002". The reference
#'         is used to extract data of table content.}
#'   \item{restriction}{restrictions applied the the table_content}
#'   \item{table_number}{table number such as "B01001"}
#'   \item{table_name}{description of table. A table has multiple columns (table_content)}
#'   \item{universe}{the universe of the data}
#' }
#'
#' @keywords datasets
#'
#' @source Check for each year of ACS 1-year and 5-year
#' \href{https://www.census.gov/programs-surveys/acs/technical-documentation/summary-file-documentation.2015.html}{Sequence Number/Table Number Lookup File}.
#'

"lookup_acs5year_2012"



# lookup_acs5year_2011 =========================================================
#' ACS 5-year 2011 file segment and table lookup data
#'
#' @docType data
#'
#' @format A data.table with 21038 rows and 7 variables
#' \describe{
#'   \item{file_segment}{sequence number of segment data files, from "0001" to "0122"}
#'   \item{table_content}{description of columns in a table}
#'   \item{reference}{reference of the table content, such as "B01001_002". The reference
#'         is used to extract data of table content.}
#'   \item{restriction}{restrictions applied the the table_content}
#'   \item{table_number}{table number such as "B01001"}
#'   \item{table_name}{description of table. A table has multiple columns (table_content)}
#'   \item{universe}{the universe of the data}
#' }
#'
#' @keywords datasets
#'
#' @source Check for each year of ACS 1-year and 5-year
#' \href{https://www.census.gov/programs-surveys/acs/technical-documentation/summary-file-documentation.2015.html}{Sequence Number/Table Number Lookup File}.
#'

"lookup_acs5year_2011"




# lookup_acs5year_2010 =========================================================
#' ACS 5-year 2010 file segment and table lookup data
#'
#' @docType data
#'
#' @format A data.table with 21487 rows and 7 variables
#' \describe{
#'   \item{file_segment}{sequence number of segment data files, from "0001" to "0122"}
#'   \item{table_content}{description of columns in a table}
#'   \item{reference}{reference of the table content, such as "B01001_002". The reference
#'         is used to extract data of table content.}
#'   \item{restriction}{restrictions applied the the table_content}
#'   \item{table_number}{table number such as "B01001"}
#'   \item{table_name}{description of table. A table has multiple columns (table_content)}
#'   \item{universe}{the universe of the data}
#' }
#'
#' @keywords datasets
#'
#' @source Check for each year of ACS 1-year and 5-year
#' \href{https://www.census.gov/programs-surveys/acs/technical-documentation/summary-file-documentation.2015.html}{Sequence Number/Table Number Lookup File}.
#'

"lookup_acs5year_2010"


# lookup_acs5year_2009 =========================================================
#' ACS 5-year 2009 file segment and table lookup data
#'
#' @docType data
#'
#' @format A data.table with 21207 rows and 7 variables
#' \describe{
#'   \item{file_segment}{sequence number of segment data files, from "0001" to "0122"}
#'   \item{table_content}{description of columns in a table}
#'   \item{reference}{reference of the table content, such as "B01001_002". The reference
#'         is used to extract data of table content.}
#'   \item{restriction}{restrictions applied the the table_content}
#'   \item{table_number}{table number such as "B01001"}
#'   \item{table_name}{description of table. A table has multiple columns (table_content)}
#'   \item{universe}{the universe of the data}
#' }
#'
#' @keywords datasets
#'
#' @source Check for each year of ACS 1-year and 5-year
#' \href{https://www.census.gov/programs-surveys/acs/technical-documentation/summary-file-documentation.2015.html}{Sequence Number/Table Number Lookup File}.
#'

"lookup_acs5year_2009"


# lookup_acs1year_2018 =========================================================
#' ACS 1-year 2018 file segment and table lookup data
#'
#' There is slightly difference in the lookup tables of each year.
#'
#' @docType data
#'
#' @format A data.table with 35502 rows and 7 variables
#' \describe{
#'   \item{file_segment}{sequence number of segment data files, from "0001" to "0166"}
#'   \item{table_content}{description of columns in a table}
#'   \item{reference}{reference of the table content, such as "B01001_002". The reference
#'         is used to extract data of table content.}
#'   \item{restriction}{restrictions applied the the table_content}
#'   \item{table_number}{table number such as "B01001"}
#'   \item{table_name}{description of table. A table has multiple columns (table_content)}
#'   \item{universe}{the universe of the data}
#' }
#'
#' @keywords datasets
#'
#' @source Check for each year of ACS 1-year and 5-year
#' \href{https://www.census.gov/programs-surveys/acs/technical-documentation/summary-file-documentation.2015.html}{Sequence Number/Table Number Lookup File}.
#'

"lookup_acs1year_2018"



# lookup_acs1year_2017 =========================================================
#' ACS 1-year 2017 file segment and table lookup data
#'
#' There is slightly difference in the lookup tables of each year.
#'
#' @docType data
#'
#' @format A data.table with 33749 rows and 7 variables
#' \describe{
#'   \item{file_segment}{sequence number of segment data files, from "0001" to "0166"}
#'   \item{table_content}{description of columns in a table}
#'   \item{reference}{reference of the table content, such as "B01001_002". The reference
#'         is used to extract data of table content.}
#'   \item{restriction}{restrictions applied the the table_content}
#'   \item{table_number}{table number such as "B01001"}
#'   \item{table_name}{description of table. A table has multiple columns (table_content)}
#'   \item{universe}{the universe of the data}
#' }
#'
#' @keywords datasets
#'
#' @source Check for each year of ACS 1-year and 5-year
#' \href{https://www.census.gov/programs-surveys/acs/technical-documentation/summary-file-documentation.2015.html}{Sequence Number/Table Number Lookup File}.
#'

"lookup_acs1year_2017"


# lookup_acs1year_2016 =========================================================
#' ACS 1-year 2016 file segment and table lookup data
#'
#' There is slightly difference in the lookup tables of each year.
#'
#' @docType data
#'
#' @format A data.table with 31835 rows and 7 variables
#' \describe{
#'   \item{file_segment}{sequence number of segment data files, from "0001" to "0166"}
#'   \item{table_content}{description of columns in a table}
#'   \item{reference}{reference of the table content, such as "B01001_002". The reference
#'         is used to extract data of table content.}
#'   \item{restriction}{restrictions applied the the table_content}
#'   \item{table_number}{table number such as "B01001"}
#'   \item{table_name}{description of table. A table has multiple columns (table_content)}
#'   \item{universe}{the universe of the data}
#' }
#'
#' @keywords datasets
#'
#' @source Check for each year of ACS 1-year and 5-year
#' \href{https://www.census.gov/programs-surveys/acs/technical-documentation/summary-file-documentation.2015.html}{Sequence Number/Table Number Lookup File}.
#'

"lookup_acs1year_2016"


# lookup_acs1year_2015 =========================================================
#' ACS 1-year 2015 file segment and table lookup data
#'
#' There is slightly difference in the lookup tables of each year.
#'
#' @docType data
#'
#' @format A data.table with 31751 rows and 7 variables
#' \describe{
#'   \item{file_segment}{sequence number of segment data files, from "0001" to "0165"}
#'   \item{table_content}{description of columns in a table}
#'   \item{reference}{reference of the table content, such as "B01001_002". The reference
#'         is used to extract data of table content.}
#'   \item{restriction}{restrictions applied the the table_content}
#'   \item{table_number}{table number such as "B01001"}
#'   \item{table_name}{description of table. A table has multiple columns (table_content)}
#'   \item{universe}{the universe of the data}
#' }
#'
#' @keywords datasets
#'
#' @source Check for each year of ACS 1-year and 5-year
#' \href{https://www.census.gov/programs-surveys/acs/technical-documentation/summary-file-documentation.2015.html}{Sequence Number/Table Number Lookup File}.
#'

"lookup_acs1year_2015"


# lookup_acs1year_2014 =========================================================
#' ACS 1-year 2014 file segment and table lookup data
#'
#' There is slightly difference in the lookup tables of each year.
#'
#' @docType data
#'
#' @format A data.table with 31711 rows and 6 variables
#' \describe{
#'   \item{file_segment}{sequence number of segment data files, from "0001" to "0165"}
#'   \item{table_content}{description of columns in a table}
#'   \item{reference}{reference of the table content, such as "B01001_002". The reference
#'         is used to extract data of table content.}
#'   \item{restriction}{restrictions applied the the table_content}
#'   \item{table_number}{table number such as "B01001"}
#'   \item{table_name}{description of table. A table has multiple columns (table_content)}
#'   \item{universe}{the universe of the data}
#' }
#'
#' @keywords datasets
#'
#' @source Check for each year of ACS 1-year and 5-year
#' \href{https://www.census.gov/programs-surveys/acs/technical-documentation/summary-file-documentation.2015.html}{Sequence Number/Table Number Lookup File}.
#'

"lookup_acs1year_2014"



# lookup_acs1year_2013 =========================================================
#' ACS 1-year 2013 file segment and table lookup data
#'
#' There is slightly difference in the lookup tables of each year.
#'
#' @docType data
#'
#' @format A data.table with 32752 rows and 7 variables
#' \describe{
#'   \item{file_segment}{sequence number of segment data files, from "0001" to "0165"}
#'   \item{table_content}{description of columns in a table}
#'   \item{reference}{reference of the table content, such as "B01001_002". The reference
#'         is used to extract data of table content.}
#'   \item{restriction}{restrictions applied the the table_content}
#'   \item{table_number}{table number such as "B01001"}
#'   \item{table_name}{description of table. A table has multiple columns (table_content)}
#'   \item{universe}{the universe of the data}
#' }
#'
#' @keywords datasets
#'
#' @source Check for each year of ACS 1-year and 5-year
#' \href{https://www.census.gov/programs-surveys/acs/technical-documentation/summary-file-documentation.2015.html}{Sequence Number/Table Number Lookup File}.
#'

"lookup_acs1year_2013"

# lookup_acs1year_2012 =========================================================
#' ACS 1-year 2012 file segment and table lookup data
#'
#' There is slightly difference in the lookup tables of each year.
#'
#' @docType data
#'
#' @format A data.table with 34394 rows and 6 variables
#' \describe{
#'   \item{file_segment}{sequence number of segment data files, from "0001" to "0165"}
#'   \item{table_content}{description of columns in a table}
#'   \item{reference}{reference of the table content, such as "B01001_002". The reference
#'         is used to extract data of table content.}
#'   \item{restriction}{restrictions applied the the table_content}
#'   \item{table_number}{table number such as "B01001"}
#'   \item{table_name}{description of table. A table has multiple columns (table_content)}
#'   \item{universe}{the universe of the data}
#' }
#'
#' @keywords datasets
#'
#' @source Check for each year of ACS 1-year and 5-year
#' \href{https://www.census.gov/programs-surveys/acs/technical-documentation/summary-file-documentation.2015.html}{Sequence Number/Table Number Lookup File}.
#'

"lookup_acs1year_2012"


# lookup_acs1year_2011 =========================================================
#' ACS 1-year 2011 file segment and table lookup data
#'
#' There is slightly difference in the lookup tables of each year.
#'
#' @docType data
#'
#' @format A data.table with 34454 rows and 6 variables
#' \describe{
#'   \item{file_segment}{sequence number of segment data files, from "0001" to "0165"}
#'   \item{table_content}{description of columns in a table}
#'   \item{reference}{reference of the table content, such as "B01001_002". The reference
#'         is used to extract data of table content.}
#'   \item{restriction}{restrictions applied the the table_content}
#'   \item{table_number}{table number such as "B01001"}
#'   \item{table_name}{description of table. A table has multiple columns (table_content)}
#'   \item{universe}{the universe of the data}
#' }
#'
#' @keywords datasets
#'
#' @source Check for each year of ACS 1-year and 5-year
#' \href{https://www.census.gov/programs-surveys/acs/technical-documentation/summary-file-documentation.2015.html}{Sequence Number/Table Number Lookup File}.
#'

"lookup_acs1year_2011"


# lookup_acs1year_2010 =========================================================
#' ACS 1-year 2010 file segment and table lookup data
#'
#' There is slightly difference in the lookup tables of each year.
#'
#' @docType data
#'
#' @format A data.table with 35240 rows and 7 variables
#' \describe{
#'   \item{file_segment}{sequence number of segment data files, from "0001" to "0166"}
#'   \item{table_content}{description of columns in a table}
#'   \item{reference}{reference of the table content, such as "B01001_002". The reference
#'         is used to extract data of table content.}
#'   \item{restriction}{restrictions applied the the table_content}
#'   \item{table_number}{table number such as "B01001"}
#'   \item{table_name}{description of table. A table has multiple columns (table_content)}
#'   \item{universe}{the universe of the data}
#' }
#'
#' @keywords datasets
#'
#' @source Check for each year of ACS 1-year and 5-year
#' \href{https://www.census.gov/programs-surveys/acs/technical-documentation/summary-file-documentation.2015.html}{Sequence Number/Table Number Lookup File}.
#'

"lookup_acs1year_2010"


# lookup_acs1year_2009 =========================================================
#' ACS 1-year 2009 file segment and table lookup data
#'
#' There is slightly difference in the lookup tables of each year.
#'
#' @docType data
#'
#' @format A data.table with 34408 rows and 7 variables
#' \describe{
#'   \item{file_segment}{sequence number of segment data files, from "0001" to "0166"}
#'   \item{table_content}{description of columns in a table}
#'   \item{reference}{reference of the table content, such as "B01001_002". The reference
#'         is used to extract data of table content.}
#'   \item{restriction}{restrictions applied the the table_content}
#'   \item{table_number}{table number such as "B01001"}
#'   \item{table_name}{description of table. A table has multiple columns (table_content)}
#'   \item{universe}{the universe of the data}
#' }
#'
#' @keywords datasets
#'
#' @source Check for each year of ACS 1-year and 5-year
#' \href{https://www.census.gov/programs-surveys/acs/technical-documentation/summary-file-documentation.2015.html}{Sequence Number/Table Number Lookup File}.
#'

"lookup_acs1year_2009"



# lookup_acs1year_2008 =========================================================
#' ACS 1-year 2008 file segment and table lookup data
#'
#' There is slightly difference in the lookup tables of each year.
#'
#' @docType data
#'
#' @format A data.table with 34403 rows and 7 variables
#' \describe{
#'   \item{file_segment}{sequence number of segment data files, from "0001" to "0166"}
#'   \item{table_content}{description of columns in a table}
#'   \item{reference}{reference of the table content, such as "B01001_002". The reference
#'         is used to extract data of table content.}
#'   \item{restriction}{restrictions applied the the table_content}
#'   \item{table_number}{table number such as "B01001"}
#'   \item{table_name}{description of table. A table has multiple columns (table_content)}
#'   \item{universe}{the universe of the data}
#' }
#'
#' @keywords datasets
#'
#' @source Check for each year of ACS 1-year and 5-year
#' \href{https://www.census.gov/programs-surveys/acs/technical-documentation/summary-file-documentation.2015.html}{Sequence Number/Table Number Lookup File}.
#'

"lookup_acs1year_2008"


# lookup_acs1year_2007 =========================================================
#' ACS 1-year 2007 file segment and table lookup data
#'
#' There is slightly difference in the lookup tables of each year.
#'
#' @docType data
#'
#' @format A data.table with 29709 rows and 7 variables
#' \describe{
#'   \item{file_segment}{sequence number of segment data files, from "0001" to "0166"}
#'   \item{table_content}{description of columns in a table}
#'   \item{reference}{reference of the table content, such as "B01001_002". The reference
#'         is used to extract data of table content.}
#'   \item{restriction}{restrictions applied the the table_content}
#'   \item{table_number}{table number such as "B01001"}
#'   \item{table_name}{description of table. A table has multiple columns (table_content)}
#'   \item{universe}{the universe of the data}
#' }
#'
#' @keywords datasets
#'
#' @source Check for each year of ACS 1-year and 5-year
#' \href{https://www.census.gov/programs-surveys/acs/technical-documentation/summary-file-documentation.2015.html}{Sequence Number/Table Number Lookup File}.
#'

"lookup_acs1year_2007"

# lookup_acs1year_2006 =========================================================
#' ACS 1-year 2006 file segment and table lookup data
#'
#' There is slightly difference in the lookup tables of each year.
#'
#' @docType data
#'
#' @format A data.table with 27986 rows and 7 variables
#' \describe{
#'   \item{file_segment}{sequence number of segment data files, from "0001" to "0166"}
#'   \item{table_content}{description of columns in a table}
#'   \item{reference}{reference of the table content, such as "B01001_002". The reference
#'         is used to extract data of table content.}
#'   \item{restriction}{restrictions applied the the table_content}
#'   \item{table_number}{table number such as "B01001"}
#'   \item{table_name}{description of table. A table has multiple columns (table_content)}
#'   \item{universe}{the universe of the data}
#' }
#'
#' @keywords datasets
#'
#' @source Check for each year of ACS 1-year and 5-year
#' \href{https://www.census.gov/programs-surveys/acs/technical-documentation/summary-file-documentation.2015.html}{Sequence Number/Table Number Lookup File}.
#'

"lookup_acs1year_2006"



# lookup_acs1year_2005 =========================================================
#' ACS 1-year 2005 file segment and table lookup data
#'
#' There is slightly difference in the lookup tables of each year.
#'
#' @docType data
#'
#' @format A data.table with 27246 rows and 7 variables
#' \describe{
#'   \item{file_segment}{sequence number of segment data files, from "0001" to "0166"}
#'   \item{table_content}{description of columns in a table}
#'   \item{reference}{reference of the table content, such as "B01001_002". The reference
#'         is used to extract data of table content.}
#'   \item{restriction}{restrictions applied the the table_content}
#'   \item{table_number}{table number such as "B01001"}
#'   \item{table_name}{description of table. A table has multiple columns (table_content)}
#'   \item{universe}{the universe of the data}
#' }
#'
#' @keywords datasets
#'
#' @source Check for each year of ACS 1-year and 5-year
#' \href{https://www.census.gov/programs-surveys/acs/technical-documentation/summary-file-documentation.2015.html}{Sequence Number/Table Number Lookup File}.
#'

"lookup_acs1year_2005"



# dict_acs_geoheaders_2005_1year ===========================================
#' List of geographic headers used in 2005 ACS 1 year survey
#'
#' @docType data
#'
#'
#' @format A data.table with 35 rows and 4 variables
#' \describe{
#'   \item{reference}{reference of the geoheader}
#'   \item{field}{description of the geoheader}
#'   \item{start}{starting position of the geoheader in geography file}
#'   \item{end}{ending position of the geoheader in geography file}
#' }
#'
#' @keywords datasets
#'
#' @source 2005 ACS Summary File
#' \href{https://www2.census.gov/programs-surveys/acs/summary_file/2005/documentation/ACS_2005_SF_Tech_Doc.pdf?#}{technical documentation},
#' page 12.
#'
#'
"dict_acs_geoheader_2005_1year"


# dict_acs_geoheaders 2006 - 2008 1 year===========================================
#' List of geographic headers used in 2006 - 2008 ACS 1 year survey
#'
#'
#' @docType data
#'
#'
#' @format A data.table with 51 rows and 4 variables
#' \describe{
#'   \item{reference}{reference of the geoheader}
#'   \item{field}{description of the geoheader}
#'   \item{start}{starting position of the geoheader in geography file}
#'   \item{end}{ending position of the geoheader in geography file}
#' }
#'
#' @keywords datasets
#'
#' @source 2008 ACS Summary File
#' \href{https://www2.census.gov/programs-surveys/acs/summary_file/2008/documentation/1_year/ACS_2008_SF_Tech_Doc.pdf?#}{technical documentation},
#' page 13.
#'
#'
"dict_acs_geoheader_2006_2008_1year"


# dict_acs_geoheaders 2009 1 year ===========================================
#' List of geographic headers in 2009 ACS 1 year survey
#'
#'
#' @docType data
#'
#'
#' @format A data.table with 50 rows and 4 variables
#' \describe{
#'   \item{reference}{reference of the geoheader}
#'   \item{field}{description of the geoheader}
#'   \item{start}{starting position of the geoheader in geography file}
#'   \item{end}{ending position of the geoheader in geography file}
#' }
#'
#' @keywords datasets
#'
#' @source 2016 ACS Summary File
#' \href{https://www2.census.gov/programs-surveys/acs/summary_file/2009/documentation/1_year/ACS_2009_SF_Tech_Doc.pdf?#}{technical documentation},
#' page 11.
#'
#'
"dict_acs_geoheader_2009_1year"


# dict_acs_geoheaders 2009 5 year===========================================
#' List of geographic headers used in ACS 5 year survey ending 2009
#'
#' @docType data
#'
#'
#' @format A data.table with 51 rows and 4 variables
#' \describe{
#'   \item{reference}{reference of the geoheader}
#'   \item{field}{description of the geoheader}
#'   \item{start}{starting position of the geoheader in geography file}
#'   \item{end}{ending position of the geoheader in geography file}
#' }
#'
#' @keywords datasets
#'
#' @source 2009 ACS Summary File
#' \href{https://www2.census.gov/programs-surveys/acs/summary_file/2009/documentation/5_year/ACS_2005-2009_SF_Tech_Doc.pdf?#}{technical documentation},
#' page 12.
#'
#'
"dict_acs_geoheader_2009_5year"

# dict_acs_geoheaders 2010 ===========================================
#' List of geographic headers used in 2010 ACS 1 and 5 year surveys
#'
#'
#' @docType data
#'
#'
#' @format A data.table with 53 rows and 4 variables
#' \describe{
#'   \item{reference}{reference of the geoheader}
#'   \item{field}{description of the geoheader}
#'   \item{start}{starting position of the geoheader in geography file}
#'   \item{end}{ending position of the geoheader in geography file}
#' }
#'
#' @keywords datasets
#'
#' @source 2016 ACS Summary File
#' \href{https://www2.census.gov/programs-surveys/acs/summary_file/2010/documentation/5_year/ACS_2006-2010_SF_Tech_Doc.pdf?#}{technical documentation},
#' page 11.
#'
#'
"dict_acs_geoheader_2010"


# dict_acs_geoheader_2011_to_now ===========================================
#' List of geographic headers used in American Community Survey since 2011
#'
#'
#' @docType data
#'
#'
#' @format A data.table with 53 rows and 4 variables
#' \describe{
#'   \item{reference}{reference of the geoheader}
#'   \item{field}{description of the geoheader}
#'   \item{start}{starting position of the geoheader in geography file}
#'   \item{end}{ending position of the geoheader in geography file}
#' }
#'
#' @keywords datasets
#'
#' @source 2016 ACS Summary File
#' \href{https://www2.census.gov/programs-surveys/acs/summary_file/2016/documentation/tech_docs/2016_SummaryFile_Tech_Doc.pdf}{technical documentation},
#' page 10.
#'
#'
"dict_acs_geoheader_2011_now"

# dict_all_summary level ======================================================
#' List of all summary levels
#'
#' @docType data
#'
#' @format A data.table with 216 rows and 2 variables
#' \describe{
#'   \item{code}{code of summary level}
#'   \item{summary_level}{description of summary level}
#' }
#'
#' @keywords datasets
#'
#' @source \href{https://factfinder.census.gov/help/en/summary_level_code_list.htm}{Summary level code list}
#'
"dict_all_summarylevel"


# dict_all_geocomponent_2010 ======================================================
#' List of all geographic components, 2010 version
#'
#' @docType data
#'
#'
#' @format A data.table with 114 rows and 2 variables:
#' \describe{
#'   \item{code}{code for the geocomponent, such as "01" and "M3"}
#'   \item{geo_component}{description of the geographic component}
#' }
#'
#' @keywords datasets
#'
#'
"dict_all_geocomponent_2010"

# dict_all_geocomponent_2000 ======================================================
#' List of all geographic components, 2000 version
#'
#' @docType data
#'
#'
#' @format A data.table with 99 rows and 2 variables:
#' \describe{
#'   \item{code}{code for the geocomponent, such as "01" and "M3"}
#'   \item{geo_component}{description of the geographic component}
#' }
#'
#' @keywords datasets
#'
#'
"dict_all_geocomponent_2000"



# dict_acs5_table ======================================================
#' List of summary levels used in ACS 5 year surverys
#'
#' @docType data
#'
#'
#' @format A data.table with 1163 rows and 12 variables:
#' \describe{
#'   \item{table_number}{table number such as "C27013"}
#'   \item{table_name}{description of the table}
#'   \item{acs5_2016}{whether the table is available in 2016}
#'   \item{acs5_2015}{whether the table is available in 2015}
#'   \item{acs5_2014}{whether the table is available in 2014}
#'   \item{acs5_2013}{whether the table is available in 2013}
#'   \item{acs5_2012}{whether the table is available in 2012}
#'   \item{acs5_2011}{whether the table is available in 2011}
#'   \item{acs5_2010}{whether the table is available in 2010}
#'   \item{acs5_2009}{whether the table is available in 2009}
#'   \item{universe}{universe of the table}
#' }

#'
"dict_acs5_table"





# dict_acs5_summary level ======================================================
#' List of summary levels used in ACS 5 year surverys
#'
#' @docType data
#'
#' @format A data.table with 87 rows and 8 variables
#' \describe{
#'   \item{code}{code of summary level}
#'   \item{summary_level}{description of summary level}
#'   \item{state_2013_to_now}{wheather a summary level available in state files since 2013}
#'   \item{state_2012}{wheather a summary level available in state files in 2012}
#'   \item{state_2009_to_2011}{wheather a summary level available in state files in 2009 - 2011}
#'   \item{US_2011_to_now}{wheather a summary level available in national files since 2011 }
#'   \item{US_2010}{wheather a summary level available in national files in 2010 }
#'   \item{US_2009}{wheather a summary level available in national files in 2009 }
#' }
#'
#' @keywords datasets
#'
#' @source generated from lookup datasets of years 2009 - 2016
#'
"dict_acs5_summarylevel"


# dict_acs5_geocomponent ======================================================
#' List of geographic components used in ACS 5 year surverys
#'
#' @docType data
#'
#'
#' @format A data.table with 19 rows and 4 variables:
#' \describe{
#'   \item{code}{code for the geocomponent, such as "01" and "M3"}
#'   \item{geo_component}{description of the geographic component}
#'   \item{state_2009_to_now}{wheather a geocomponent available in state files since 2009}
#'   \item{US_2009_to_now}{wheather a geocomponent available in national files since 2009}
#' }
#'
#' @keywords datasets
#'
#'
"dict_acs5_geocomponent"

# dict_acs1_table ======================================================
#' List of summary levels used in ACS 1 year surverys
#'
#' @docType data
#'
#'
#' @format A data.table with 1811 rows and 16 variables:
#' \describe{
#'   \item{table_number}{table number such as "C27013"}
#'   \item{table_name}{description of the table}
#'   \item{acs1_2017}{whether the table is available in 2018}
#'   \item{acs1_2017}{whether the table is available in 2017}
#'   \item{acs1_2016}{whether the table is available in 2016}
#'   \item{acs1_2015}{whether the table is available in 2015}
#'   \item{acs1_2014}{whether the table is available in 2014}
#'   \item{acs1_2013}{whether the table is available in 2013}
#'   \item{acs1_2012}{whether the table is available in 2012}
#'   \item{acs1_2011}{whether the table is available in 2011}
#'   \item{acs1_2010}{whether the table is available in 2010}
#'   \item{acs1_2009}{whether the table is available in 2009}
#'   \item{acs1_2008}{whether the table is available in 2008}
#'   \item{acs1_2007}{whether the table is available in 2007}
#'   \item{acs1_2006}{whether the table is available in 2006}
#'   \item{acs1_2005}{whether the table is available in 2005}
#'   \item{universe}{universe of the table}
#' }

#'
"dict_acs1_table"

# dict_acs1_summary level ======================================================
#' List of summary levels used in ACS 1 year surverys
#'
#' @docType data
#'
#'
#' @format A data.table with 23 rows and 5 variables
#' \describe{
#'   \item{code}{code of summary level}
#'   \item{summary_level}{description of summary level}
#'   \item{state_2006_to_now}{wheather a summary level available in state files since 2006}
#'   \item{state_2005}{wheather a summary level available in state files in 2005}
#'   \item{US_2005_to_now}{wheather a summary level available in national files since 2005}
#' }
#'

#'
"dict_acs1_summarylevel"

# dict_acs1_geocomponent ======================================================
#' List of geographic components used in ACS 1 year surverys
#'
#' @docType data
#'
#'
#' @format A data.table with 28 rows and 9 variables:
#' \describe{
#'   \item{code}{code for the geocomponent, such as "01" and "M3"}
#'   \item{geo_component}{description of the geographic component}
#'   \item{state_2009_to_now}{wheather a geocomponent available in state files since 2009}
#'   \item{state_2007_2008}{wheather a geocomponent available in state files in 2007 and 2008}
#'   \item{state_2005_2006}{wheather a geocomponent available in state files in 2005 and 2006}
#'   \item{US_2009_to_now}{wheather a geocomponent available in national files since 2009}
#'   \item{US_2007_2008}{wheather a geocomponent available in national files in 2007 and 2008}
#'   \item{US_2006}{wheather a geocomponent available in national files in 2006}
#'   \item{US_2005}{wheather a geocomponent available in national files in 2005}
#'
#' }
#'

#'
"dict_acs1_geocomponent"
