% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qqtopr.R
\name{qqtopr}
\alias{qqtopr}
\title{Create a QQ plot}
\usage{
qqtopr(
  dat,
  scale = 1,
  n_variants = 0,
  breaks = 15,
  title = NULL,
  color = get_topr_colors(),
  size = 1,
  legend_name = "",
  legend_position = "right",
  legend_labels = NULL,
  axis_text_size = 11,
  axis_title_size = 12,
  title_text_size = 13,
  legend_title_size = 12,
  legend_text_size = 12
)
}
\arguments{
\item{dat}{Dataframe or a list of dataframes (required columns is \code{P})) of association results.}

\item{scale}{An integer, plot elements scale, default: 1}

\item{n_variants}{An integer, total number of variants used in the study}

\item{breaks}{A number setting the breaks for the axes}

\item{title}{A string}

\item{color}{A string or vector of strings setting the color/s for the input dataset/s}

\item{size}{An integer setting the size of the plot points (default: \code{size=1.2})}

\item{legend_name}{A string, use to change the name of the legend (default: None)}

\item{legend_position}{A string, top,bottom,left or right}

\item{legend_labels}{A string or vector of strings representing legend labels for the input dataset/s}

\item{axis_text_size}{A number, size of the x and y axes tick labels (default: 12)}

\item{axis_title_size}{A number, size of the x and y title labels (default: 12)}

\item{title_text_size}{A number, size of the plot title (default: 13)}

\item{legend_title_size}{A number, size of the legend title}

\item{legend_text_size}{A number, size of the legend text}
}
\value{
ggplot
}
\description{
\code{qqtopr()} displays QQ plots for association data.
Required parameter is at least one dataset (dataframe) containing the association data (with columns \code{CHROM,POS,P}
}
