% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_genes_and_annotation.R
\name{annotate_with_nearest_gene}
\alias{annotate_with_nearest_gene}
\title{Get the nearest gene for one or more snps}
\usage{
annotate_with_nearest_gene(variants, protein_coding_only = FALSE)
}
\arguments{
\item{variants}{a dataframe of variant positions (CHROM and POS)}

\item{protein_coding_only}{Logical, if set to TRUE only annotate with protein coding genes (the default value is FALSE)}
}
\value{
the input dataframe with Gene_Symbol as an additional column
}
\description{
\code{annotate_with_nearest_gene()} Annotate the variant/snp with their nearest gene
Required parameters is a dataframe of SNPs (with the columns CHROM and POS)
}
\examples{
variants <-get_best_snp_per_MB(CD_UKBB)
annotate_with_nearest_gene(variants)

}
