% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptive_sampling.R
\name{profile_likelihood}
\alias{profile_likelihood}
\title{Profile Likelihood Analysis}
\usage{
profile_likelihood(
  param,
  samples,
  grid_size = 40,
  bandwidth_factor = 0.05,
  start_factor = 0.5,
  end_factor = 1.5,
  min_samples = 5
)
}
\arguments{
\item{param}{Character name of parameter to analyze}

\item{samples}{Data frame containing parameter samples and log-likelihoods}

\item{grid_size}{Integer number of grid points (default: 48)}

\item{bandwidth_factor}{Numeric factor for local sample window (default: 0.03)}

\item{start_factor, end_factor}{Numeric range multipliers for parameter grid (default: 0.5, 1.2)}

\item{min_samples}{Integer minimum samples required for reliable estimate (default: 10)}
}
\value{
Object of class "profile_likelihood" containing:
\item{param}{Vector of parameter values}
\item{ll}{Vector of log-likelihood values}
\item{param_name}{Name of analyzed parameter}
\item{bandwidth}{Bandwidth used for local windows}
\item{sample_counts}{Number of samples per estimate}
}
\description{
Calculates profile likelihood for a parameter by evaluating conditional maximum
likelihood across a grid of parameter values. Uses local sample windowing to
estimate conditional likelihoods. This implementation is not a classical profile likelihood
calculation, but rather an "empirical profile likelihood" which estimates the profile
likelihood at each point based on the many observations previously sampled in Monte Carlo simulations.
}
\details{
For each value in the parameter grid, the function:
\enumerate{
\item Identifies nearby samples using bandwidth window
\item Calculates conditional maximum likelihood from these samples
\item Tracks sample counts to assess estimate reliability
\item Handles boundary conditions and sparse regions
}
}
\examples{
# Create a sample data frame of MCMC samples
mcmc_samples <- data.frame(
  log_N = log(runif(50, 2, 10)),
  log_k0 = log(runif(50, 1, 5)),
  log_cooling_rate = log(runif(50, 0.01, 0.1)),
  log_c_repulsion = log(runif(50, 0.1, 1)),
  NLL = runif(50, 20, 100)
)

# Calculate profile likelihood for parameter "log_N"
pl <- profile_likelihood("log_N", mcmc_samples, 
                        grid_size = 10, # Smaller grid for a quick example
                        bandwidth_factor = 0.05)
                        
# Print the results
print(pl)

}
\seealso{
\code{\link{plot.profile_likelihood}} for visualization
}
