% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptive_sampling.R
\name{plot.parameter_sensitivity}
\alias{plot.parameter_sensitivity}
\title{Plot Method for Parameter Sensitivity Analysis}
\usage{
\method{plot}{parameter_sensitivity}(
  x,
  width = 3.5,
  height = 3.5,
  save_plot = FALSE,
  output_dir,
  y_limit_factor = NULL,
  ...
)
}
\arguments{
\item{x}{A parameter_sensitivity object}

\item{width}{Numeric width of output plot in inches (default: 3.5)}

\item{height}{Numeric height of output plot in inches (default: 3.5)}

\item{save_plot}{Logical. Whether to save plot to file. Default: FALSE}

\item{output_dir}{Character. Directory for output files. Required if \code{save_plot} is TRUE.}

\item{y_limit_factor}{Numeric. Factor to set the upper y-axis limit as a percentage above
the threshold value (e.g., 1.10 for 10\% above). Default: NULL (automatic scaling)}

\item{...}{Additional arguments passed to plot}
}
\value{
A ggplot object
}
\description{
Creates a visualization of parameter sensitivity showing minimum MAE values
across parameter ranges with threshold indicators.
}
