% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar-props.R
\name{cal_props}
\alias{cal_props}
\title{Calendar properties}
\usage{
cal_props(cal, ...)
}
\arguments{
\item{cal}{A \code{\link[=calendar]{calendar()}} object.}

\item{...}{Either named arguments to use as calendar properties or a
\code{data.frame} with rows as calendars and columns as properties.
See \url{https://nhn.github.io/tui.calendar/latest/CalendarInfo/} for options.}
}
\value{
A \code{calendar} htmlwidget.
}
\description{
Define calendar properties for grouping schedules under common theme.
}
\examples{
library(toastui)

# Define theme for schedules
calendar(cal_demo_data()[, -c(9, 10, 11)]) \%>\%
  cal_props(
    list(
      id = "1",
      name = "PERSO",
      color = "lightblue",
      backgroundColor = "purple",
      borderColor = "magenta"
    ),
    list(
      id = "2",
      name = "WORK",
      color = "red",
      backgroundColor = "yellow",
      borderColor = "orange"
    )
  )
}
