% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar-proxy.R
\name{cal_proxy_clear}
\alias{cal_proxy_clear}
\title{Clear calendar with Proxy}
\usage{
cal_proxy_clear(proxy)
}
\arguments{
\item{proxy}{A \code{\link[=calendar_proxy]{calendar_proxy()}} \code{htmlwidget} object.}
}
\value{
A \code{calendar_proxy} object.
}
\description{
This function allow to delete all schedules and clear view.
}
\examples{

library(shiny)
library(toastui)

ui <- fluidPage(
  tags$h2("Clear all schedules"),
  actionButton("clear", "Clear all", class = "btn-block btn-danger"),
  calendarOutput("my_calendar")
)

server <- function(input, output, session) {

  output$my_calendar <- renderCalendar({
    calendar(cal_demo_data(), navigation = FALSE)
  })

  observeEvent(input$clear, cal_proxy_clear("my_calendar"))
}

if (interactive())
  shinyApp(ui, server)
}
\seealso{
Other calendar proxy methods: 
\code{\link{cal_proxy_options}()},
\code{\link{cal_proxy_toggle}()},
\code{\link{cal_proxy_view}()},
\code{\link{calendar-proxy-navigate}},
\code{\link{calendar-proxy-schedule}},
\code{\link{calendar_proxy}()}
}
\concept{calendar proxy methods}
