\name{computeBarchart}
\alias{computeBarchart}
\title{Compute one or more aggregates across single class.}
\usage{
  computeBarchart(channel, tableName, category,
    aggregates = "COUNT(*) cnt", where = NULL,
    orderBy = NULL, top = NULL, by = NULL,
    withMelt = FALSE, stringsAsFactors = FALSE,
    test = FALSE)
}
\arguments{
  \item{channel}{connection object as returned by
  \code{\link{odbcConnect}}}

  \item{tableName}{table name}

  \item{category}{column name or expression associated with
  categories. Name may be valid SQL expression and can
  contain otional alias (e.g. \code{"UPPER(car_make)
  make"})}

  \item{aggregates}{SQL aggregates to compute. Each
  aggregate corresponds to category value.  Aggregates may
  have optional aliases like in \code{"AVG(era) era"}}

  \item{by}{for optional grouping by one or more columns
  for faceting or alike (effectively these elements will be
  part of \code{GROUP BY ...})}

  \item{where}{specifies criteria to satisfy by the table
  rows before applying computation. The creteria are
  expressed in the form of SQL predicates (inside
  \code{WHERE} clause).}

  \item{orderBy}{list of column names, aliases, references
  or their combinations to use in SQL \code{ORDER BY}
  clause. Use in combination with \code{top} below to
  compute only limited number of results in certain order.}

  \item{top}{if specified indicates number of bars to
  include in bar plot. In combination with \code{orderBy}
  it works as computing first \code{top} results in certain
  order.}

  \item{withMelt}{logical if TRUE then uses \pkg{reshape2}
  \code{\link{melt}} to transform result data frame
  aggregate values into a molten data frame}

  \item{stringsAsFactors}{logical: should columns returned
  as character and not excluded by \code{as.is} and not
  converted to anything else be converted to factors?}

  \item{test}{logical: if TRUE show what would be done,
  only (similar to parameter \code{test} in \link{RODBC}
  functions like \link{sqlQuery} and \link{sqlSave}).}
}
\value{
  Data frame to use for bar chart plots with
  \code{\link{createHistogram}}.
}
\description{
  Compute aggregates across category class represented by
  the table column. Values are one or more SQL aggregates
  that are valid expressions with \code{GROUP BY <class
  column>}. Class column usually is of character or other
  discrete type. Typical example is computing a bar chart
  for the column using SQL \code{COUNT(*) ... GROUP BY} -
  hence the name of the function. Result is a data frame to
  visualize as bar charts or heatmaps (see creating
  visualizations with \code{\link{createHistogram}} and
  \code{\link{createHeatmap}}).
}
\examples{
\donttest{
# Compute average team season era, walks, and hits for each decade starting with 1980
computeBarchart(channel=conn, "teams_enh", "teamid team",
                aggregates=c("avg(era) era", "avg(bb) bb", "avg(h) h"),
                where="yearid >=1980", by=c("decadeid"))

# multipe aggregates in the same bar chart (with melt)
bc = computeBarchart(channel=conn, tableName="pitching_enh", category="teamid",
                    aggregates=c("AVG(era) era", "AVG(whip) whip"), withMelt=TRUE,
                    where="yearid >= 2000 and lgid='AL'")

# adding facets by decadeid
bc = computeBarchart(channel=conn, tablelName="pitching_enh", category="teamid",
                     aggregates=c("AVG(era) era", "AVG(whip) whip", "AVG(ktobb) ktobb"),
                     where="yearid >= 1990 and lgid='AL'", by="decadeid", withMelt=TRUE)
}
}
\seealso{
  \code{\link{computeHistogram}},
  \code{\link{createHistogram}}
}

