% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bart_season_schedule.R
\name{bart_season_schedule}
\alias{bart_season_schedule}
\title{Get Full Season Schedule}
\usage{
bart_season_schedule(
  year = current_season(),
  type = NULL,
  conf = NULL,
  team = NULL
)
}
\arguments{
\item{year}{Defaults to current season (YYYY).}

\item{type}{Filters for game type (see details).}

\item{conf}{Filters for conference.}

\item{team}{Filters for team.}
}
\value{
Returns a tibble with six columns:
\describe{
  \item{\code{date}}{double.}
  \item{\code{type}}{character. See details.}
  \item{\code{neutral}}{logical.}
  \item{\code{home}}{character.}
  \item{\code{away}}{character.}
  \item{\code{game_id}}{character.}
}
}
\description{
Returns full season schedule for all D-1 teams by year
}
\details{
Function pulls all games involving at least one D-1 team. Under the `type`
column, games are classified by one of four indicators, explained below:
\describe{ \item{nc}{Non-conference games between two D-1 teams.}
\item{conf}{In-conference games.} \item{post}{Post-conference tournament
games.} \item{nond1}{Games involving one non-D1 team.} }
}
\examples{
\donttest{try(bart_season_schedule(year=2022))}

}
