% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sp_.R
\name{sp_list}
\alias{sp_list}
\alias{sp_list_drives}
\alias{sp_list_sites}
\alias{sp_list_subsites}
\title{List Sharepoint Contents}
\usage{
sp_list(
  folder = "",
  site = NULL,
  drive = NULL,
  pattern = NULL,
  full_names = FALSE,
  recursive = FALSE,
  include_dirs = FALSE
)

sp_list_drives(site = NULL, pattern = NULL)

sp_list_sites(pattern = NULL)

sp_list_subsites(site = NULL, pattern = NULL)
}
\arguments{
\item{folder}{Path to the folder. By default, lists the top-level contents of the drive.}

\item{site}{Site identifier. Can be the site name, id, URL, or an ms_site object. If no site identifier is provided, uses the stored default site if it exists.}

\item{drive}{Drive identifier. Can be the drive name, id, or an ms_drive object. If site is provided but drive is not, uses the first drive of the provided site. If neither is provided, uses the stored default drive if it exists.}

\item{pattern}{Optional regular expression. Only names which match the regular expression will be returned.}

\item{full_names}{logical. If TRUE, the directory path is prepended to the file names to give a relative file path. If FALSE, the file names (rather than paths) are returned.}

\item{recursive}{logical. Should the listing recurse into directories? If TRUE, full_names is also set to TRUE.}

\item{include_dirs}{logical. Should subdirectory names be included in recursive listings? (They always are in non-recursive ones)}
}
\value{
A tibble with name and additional information on the relevant sites/drives/files
}
\description{
Lists site/subsite/drive/folder contents. Can be used with default site/drive set by
\code{\link[=sp_defaults]{sp_defaults()}} or with a specified site/drive.
\itemize{
\item \code{sp_list()} lists the contents of a Sharepoint Drive or a folder.
\item \code{sp_list_drives()} lists the drives contained in a Sharepoint site.
\item \code{sp_list_subsites()} lists any subsites of the specified Sharepoint site.
\item \code{sp_list_sites()} lists the sites you have access to. These are the sites you are following in Sharepoint
}
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# List drives from the default site
sp_list_drives()

# List drives from a specific site
sp_list_drives("Data Analytics")
\dontshow{\}) # examplesIf}
}
