% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_mosaic.group_tna}
\alias{plot_mosaic.group_tna}
\title{Plot state frequencies as a mosaic between two groups}
\usage{
\method{plot_mosaic}{group_tna}(x, label, digits = 1, ...)
}
\arguments{
\item{x}{A \code{group_tna} object.}

\item{label}{An optional \code{character} string that can be provided to specify
the grouping factor name if \code{x} was not constructed using a column name of
the original data.}

\item{digits}{An \code{integer} that determines the number of digits to use
for the chi-square test statistic and the p-value in the plot.}

\item{...}{Ignored.}
}
\value{
A \code{ggplot} object.
}
\description{
Plot state frequencies as a mosaic between two groups
}
\examples{
model <- group_model(engagement_mmm)
plot_mosaic(model)

}
\seealso{
Cluster-related functions
\code{\link{bootstrap}()},
\code{\link{centralities}()},
\code{\link{cliques}()},
\code{\link{communities}()},
\code{\link{deprune}()},
\code{\link{estimate_cs}()},
\code{\link{group_model}()},
\code{\link{hist.group_tna}()},
\code{\link{mmm_stats}()},
\code{\link{plot.group_tna}()},
\code{\link{plot.group_tna_centralities}()},
\code{\link{plot.group_tna_cliques}()},
\code{\link{plot.group_tna_communities}()},
\code{\link{plot.group_tna_stability}()},
\code{\link{plot_compare.group_tna}()},
\code{\link{plot_mosaic.tna_data}()},
\code{\link{print.group_tna}()},
\code{\link{print.group_tna_bootstrap}()},
\code{\link{print.group_tna_centralities}()},
\code{\link{print.group_tna_cliques}()},
\code{\link{print.group_tna_communities}()},
\code{\link{print.group_tna_stability}()},
\code{\link{print.summary.group_tna}()},
\code{\link{print.summary.group_tna_bootstrap}()},
\code{\link{prune}()},
\code{\link{pruning_details}()},
\code{\link{rename_groups}()},
\code{\link{reprune}()},
\code{\link{summary.group_tna}()},
\code{\link{summary.group_tna_bootstrap}()}
}
\concept{clusters}
