% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.group_tna_centralities}
\alias{plot.group_tna_centralities}
\title{Plot Centrality Measures}
\usage{
\method{plot}{group_tna_centralities}(
  x,
  reorder = TRUE,
  ncol = 4,
  scales = c("free_x", "fixed"),
  colors,
  labels = TRUE,
  ...
)
}
\arguments{
\item{x}{A \code{group_tna_centralities} object.}

\item{reorder}{A \code{logical} value indicating whether to reorder the values
for each centrality in a descending order. The default is \code{TRUE}.}

\item{ncol}{Number of columns to use for the facets. The default is 3.}

\item{scales}{Either \code{"fixed"} or \code{"free_x"} (the default). If \code{"free_x"},
the horizontal axis is scaled individually in each facet. If \code{"fixed"},
the same values are used for all axes.}

\item{colors}{The colors for each node (default is the model colors
if the \code{tna} model object is passed, otherwise \code{"black"}).}

\item{labels}{A \code{logical} value indicating whether to show the centrality
numeric values. The default is \code{TRUE}.}

\item{...}{Ignored.}
}
\value{
A \code{ggplot} object displaying a line chart for each centrality
with one line per cluster.
}
\description{
Plot Centrality Measures
}
\examples{
model <- group_model(engagement_mmm)
cm <- centralities(model)
plot(cm)

}
\seealso{
Cluster-related functions
\code{\link{bootstrap}()},
\code{\link{centralities}()},
\code{\link{cliques}()},
\code{\link{communities}()},
\code{\link{deprune}()},
\code{\link{estimate_cs}()},
\code{\link{group_model}()},
\code{\link{hist.group_tna}()},
\code{\link{mmm_stats}()},
\code{\link{plot.group_tna}()},
\code{\link{plot.group_tna_cliques}()},
\code{\link{plot.group_tna_communities}()},
\code{\link{plot.group_tna_stability}()},
\code{\link{print.group_tna}()},
\code{\link{print.group_tna_bootstrap}()},
\code{\link{print.group_tna_centralities}()},
\code{\link{print.group_tna_cliques}()},
\code{\link{print.group_tna_communities}()},
\code{\link{print.group_tna_stability}()},
\code{\link{print.summary.group_tna}()},
\code{\link{print.summary.group_tna_bootstrap}()},
\code{\link{prune}()},
\code{\link{pruning_details}()},
\code{\link{rename_groups}()},
\code{\link{reprune}()},
\code{\link{summary.group_tna}()},
\code{\link{summary.group_tna_bootstrap}()}
}
\concept{clusters}
