% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projection_units.R
\name{projection_units}
\alias{projection_units}
\title{Get or translate units of a projection}
\usage{
projection_units(x = NA, target = "m", orig = NA, to = NA,
  latitude = 0, show.warnings = TRUE)
}
\arguments{
\item{x}{A projection (see \code{\link{get_proj4}}) or a shape (from class \code{\link[sp:Spatial]{Spatial}}, \code{\link[raster:Raster-class]{Raster}}), or \code{sf}.}

\item{target}{target unit, one of:  \code{"m"}, \code{"km"}, \code{"mi"}, and \code{"ft"}.}

\item{orig}{units by the \code{x} is defined. Only needed if this information is missing from \code{x} and \code{x} is projected. Options:  \code{"m"}, \code{"km"}, \code{"mi"}, and \code{"ft"}.}

\item{to}{multiplier used as follows: \code{orig * to = target}. Only needed when \code{orig} or \code{target} is unknown. For instance, if \code{target} is set to \code{"hm"} (hectameter), and \code{orig} is \code{"m"}, then \code{to} should be 100, meaning 1 hectameter equals 100 meters.}

\item{latitude}{latitude. Needed if the projection coordinates are in latitude longitude units. In that case the \code{orig} will be defined as longitude coordinates at latitude \code{latitude}.}

\item{show.warnings}{should warnings be shown?}
}
\value{
list with the following items, \code{orig}, \code{target}, and \code{to} either according the specified argument, or determined determined. The value is \code{NA} for items that cannot be determined. The final item is \code{projected}, which is determined using \code{\link{is_projected}}
}
\description{
Get the units from a projection (CRS) or a shape and determine the multiplier to transpose it in other units.
}
\examples{
\dontrun{
if (require(tmap)) {
    data(World, land)
    projection_units(World, target = "mi")

    projection_units(land)
    projection_units(land, latitude = 45)
    projection_units(land, latitude = 89)
}
}
}
\seealso{
\code{\link{approx_distances}} for distances between two points and \code{\link{approx_areas}} for areas.
}

