% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmap_mode.R
\name{tmap_style}
\alias{tmap_style}
\title{Set the default tmap style}
\usage{
tmap_style(style)
}
\arguments{
\item{style}{name of the style. The function \code{tm_style_<style>} should exist and be a wrapper of \code{\link{tm_layout}}. The default style when loading the package is \code{"white"}, which corresponds to the function \code{\link{tm_style_white}}.}
}
\value{
the style before changing
}
\description{
Set the default tmap style, which is contained in the global option \code{tmap.style}.
}
\examples{
data(World)

current.style <- tmap_style("classic")
qtm(World, fill="life_exp", fill.title="Life expectancy")

tmap_style("cobalt")
qtm(World, fill="life_exp", fill.title="Life expectancy")

# restore current style
tmap_style(current.style)
}
\seealso{
\code{\link{tm_layout}} for predefined styles, and \code{\link{style_catalogue}} to create a style catelogue of all available styles.
}

