% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_osm.R
\name{read_osm}
\alias{osm_line}
\alias{osm_point}
\alias{osm_poly}
\alias{read_osm}
\title{Read Open Street Map data}
\usage{
read_osm(x, raster = NA, zoom = NULL, type = NULL, minNumTiles = NULL,
  mergeTiles = NULL, ...)

osm_poly(query)

osm_line(query)

osm_point(query)
}
\arguments{
\item{x}{bounding box or \code{\link[osmar:osmar]{osmar}} object}

\item{raster}{logical that determines whether a raster or vector shapes are returned. In the latter case, specify the vector selections (see argument \code{...}). By default, \code{raster=TRUE} if no vector selections are made, and \code{raster=FALSE} otherwise.}

\item{zoom}{passed on to \code{\link[OpenStreetMap:openmap]{openmap}}. Only applicable when \code{raster=TRUE}.}

\item{type}{passed on to \code{\link[OpenStreetMap:openmap]{openmap}} Only applicable when \code{raster=TRUE}.}

\item{minNumTiles}{passed on to \code{\link[OpenStreetMap:openmap]{openmap}} Only applicable when \code{raster=TRUE}.}

\item{mergeTiles}{passed on to \code{\link[OpenStreetMap:openmap]{openmap}} Only applicable when \code{raster=TRUE}.}

\item{...}{arguments that specify polygons, lines, and/or points queries, created with \code{osm_poly}, \code{osm_line}, and \code{osm_point} respectively.}

\item{query}{query to select polygons, lines, or points. Currently, two formats are supported: 1) key, 2) key=value. See \url{http://wiki.openstreetmap.org/wiki/Map_Features} for Open Street Map keys and values.}
}
\value{
The output of \code{read_osm} is a \code{\link[sp:SpatialGridDataFrame]{SpatialGridDataFrame}} if \code{raster=TRUE}, and otherwise a named list of \code{\link[sp:SpatialPolygonsDataFrame]{SpatialPolygonsDataFrame}}, \code{\link[sp:SpatialLinesDataFrame]{SpatialLinesDataFrame}}, and/or \code{\link[sp:SpatialPointsDataFrame]{SpatialPointsDataFrame}} objects. The names of this list are the names of arguments defined at \code{...}.
}
\description{
Read Open Street Map data. Either OSM tiles are read and returned as a spatial raster, or vectorized OSM data are queried and returned as spatial polygons, lines, and/or points.
}
\examples{
\dontrun{
#### Choropleth with OSM background

# load Netherlands shape
data(NLD_muni)

# read OSM raster data
osm_NLD <- read_osm(bb(NLD_muni, ext=1.1, projection ="longlat"))


# plot with regular tmap functions
tm_shape(osm_NLD) +
	tm_raster() +
tm_shape(NLD_muni) +
	tm_polygons("population", convert2density=TRUE, style="kmeans", alpha=.7, palette="Purples")

#### A close look at Aalborg Congress Centre (host for the useR2014)

# define bounding box of Aalborg Congress Centre
bb_Aal <- bb(xlim = c(9.9075, 9.9175), ylim=c(57.043, 57.046))

# read OSM raster data
rast_Aal <- read_osm(bb_Aal, type="mapquest")

# raster OSM of Aalburg
qtm(rast_Aal)

# read OSM vector data
vec_Aal <- read_osm(bb_Aal,
					buildings=osm_poly("building"),
					roads=osm_line("highway"),
					trees=osm_point("natural=tree"),
					park=osm_poly("leisure=park"),
					cemetery=osm_poly("landuse=cemetery"),
					railway=osm_line("railway"),
					parking=osm_poly("amenity=parking"))

# vector OSM of Aalburg
tm_shape(vec_Aal$park, bbox=bb_Aal) +
	tm_polygons(col = "darkolivegreen3") +
tm_shape(vec_Aal$cemetery) +
	tm_polygons(col="darkolivegreen3") +
tm_shape(vec_Aal$parking) +
	tm_polygons(col="grey85") +
tm_shape(vec_Aal$building) +
	tm_polygons(col = "gold") +
tm_shape(vec_Aal$roads) +
	tm_lines("grey40", lwd = 3) +
tm_shape(vec_Aal$trees) + 
	tm_bubbles(size=.25, col="forestgreen") +
tm_shape(vec_Aal$railway) +
	tm_lines(col = "grey40", lwd = 3, lty = "longdash") +
tm_layout(inner.margins=0, bg.color="grey95")
}
}

