% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_method_20_kRp.corpus_get_set_is.R
\docType{methods}
\name{taggedText,kRp.corpus-method}
\alias{taggedText,kRp.corpus-method}
\alias{taggedText,-methods}
\alias{taggedText<-,kRp.corpus-method}
\alias{taggedText<-,-methods}
\alias{doc_id,kRp.corpus-method}
\alias{doc_id,-methods}
\alias{describe,kRp.corpus-method}
\alias{describe,-methods}
\alias{describe<-,kRp.corpus-method}
\alias{describe<-,-methods}
\alias{language,kRp.corpus-method}
\alias{language,-methods}
\alias{language<-,kRp.corpus-method}
\alias{language<-,-methods}
\alias{hasFeature,kRp.corpus-method}
\alias{hasFeature,-methods}
\alias{hasFeature<-,kRp.corpus-method}
\alias{hasFeature<-,-methods}
\alias{feature,kRp.corpus-method}
\alias{feature,-methods}
\alias{feature<-,kRp.corpus-method}
\alias{feature<-,-methods}
\alias{corpusReadability,kRp.corpus-method}
\alias{corpusReadability,-methods}
\alias{corpusReadability<-,kRp.corpus-method}
\alias{corpusReadability<-,-methods}
\alias{corpusTm}
\alias{corpusTm,kRp.corpus-method}
\alias{corpusTm,-methods}
\alias{corpusTm<-}
\alias{corpusTm<-,kRp.corpus-method}
\alias{corpusTm<-,-methods}
\alias{corpusMeta}
\alias{corpusMeta,kRp.corpus-method}
\alias{corpusMeta,-methods}
\alias{corpusMeta<-}
\alias{corpusMeta<-,kRp.corpus-method}
\alias{corpusMeta<-,-methods}
\alias{corpusHyphen,kRp.corpus-method}
\alias{corpusHyphen,-methods}
\alias{corpusHyphen<-,kRp.corpus-method}
\alias{corpusHyphen<-,-methods}
\alias{corpusLexDiv,kRp.corpus-method}
\alias{corpusLexDiv,-methods}
\alias{corpusLexDiv<-,kRp.corpus-method}
\alias{corpusLexDiv<-,-methods}
\alias{corpusFreq,kRp.corpus-method}
\alias{corpusFreq,-methods}
\alias{corpusFreq<-,kRp.corpus-method}
\alias{corpusFreq<-,-methods}
\alias{corpusCorpFreq,kRp.corpus-method}
\alias{corpusCorpFreq,-methods}
\alias{corpusCorpFreq<-,kRp.corpus-method}
\alias{corpusCorpFreq<-,-methods}
\alias{corpusHierarchy}
\alias{corpusHierarchy,kRp.corpus-method}
\alias{corpusHierarchy,-methods}
\alias{corpusHierarchy<-}
\alias{corpusHierarchy<-,kRp.corpus-method}
\alias{corpusHierarchy<-,-methods}
\alias{corpusFiles}
\alias{corpusFiles,kRp.corpus-method}
\alias{corpusFiles,-methods}
\alias{corpusFiles<-}
\alias{corpusFiles<-,kRp.corpus-method}
\alias{corpusFiles<-,-methods}
\alias{corpusDocTermMatrix}
\alias{corpusDocTermMatrix,kRp.corpus-method}
\alias{corpusDocTermMatrix,-methods}
\alias{corpusDocTermMatrix<-}
\alias{corpusDocTermMatrix<-,kRp.corpus-method}
\alias{corpusDocTermMatrix<-,-methods}
\alias{corpusStopwords,kRp.corpus-method}
\alias{corpusStopwords,-methods}
\alias{corpusStopwords<-,kRp.corpus-method}
\alias{corpusStopwords<-,-methods}
\alias{diffText,kRp.corpus-method}
\alias{diffText,-methods}
\alias{diffText<-,kRp.corpus-method}
\alias{diffText<-,-methods}
\alias{originalText,kRp.corpus-method}
\alias{originalText,-methods}
\alias{is.corpus}
\alias{[,kRp.corpus,ANY,ANY,ANY-method}
\alias{[,-methods}
\alias{[<-,kRp.corpus,ANY,ANY,ANY-method}
\alias{[<-,-methods}
\alias{[[,kRp.corpus-method}
\alias{[[,-methods}
\alias{[[,kRp.corpus,ANY-method}
\alias{[[<-,kRp.corpus-method}
\alias{[[<-,-methods}
\alias{[[<-,kRp.corpus,ANY,ANY-method}
\alias{tif_as_tokens_df,kRp.corpus-method}
\alias{tif_as_tokens_df,-methods}
\alias{tif_as_tokens_df,hierarchy-method}
\alias{tif_as_corpus_df}
\alias{tif_as_corpus_df,kRp.corpus-method}
\alias{tif_as_corpus_df,-methods}
\alias{tif_as_corpus_df,hierarchy-method}
\title{Getter/setter methods for kRp.corpus objects}
\usage{
\S4method{taggedText}{kRp.corpus}(obj)

\S4method{taggedText}{kRp.corpus}(obj) <- value

\S4method{doc_id}{kRp.corpus}(obj, has_id = NULL)

\S4method{describe}{kRp.corpus}(obj, doc_id = NULL, simplify = TRUE, ...)

\S4method{describe}{kRp.corpus}(obj, doc_id = NULL, ...) <- value

\S4method{language}{kRp.corpus}(obj)

\S4method{language}{kRp.corpus}(obj) <- value

\S4method{hasFeature}{kRp.corpus}(obj, feature = NULL)

\S4method{hasFeature}{kRp.corpus}(obj, feature) <- value

\S4method{feature}{kRp.corpus}(obj, feature, doc_id = NULL)

\S4method{feature}{kRp.corpus}(obj, feature) <- value

\S4method{corpusReadability}{kRp.corpus}(obj, doc_id = NULL)

\S4method{corpusReadability}{kRp.corpus}(obj) <- value

corpusTm(obj)

\S4method{corpusTm}{kRp.corpus}(obj)

corpusTm(obj) <- value

\S4method{corpusTm}{kRp.corpus}(obj) <- value

corpusMeta(obj, meta = NULL, fail = TRUE)

\S4method{corpusMeta}{kRp.corpus}(obj, meta = NULL, fail = TRUE)

corpusMeta(obj, meta = NULL) <- value

\S4method{corpusMeta}{kRp.corpus}(obj, meta = NULL) <- value

\S4method{corpusHyphen}{kRp.corpus}(obj, doc_id = NULL)

\S4method{corpusHyphen}{kRp.corpus}(obj) <- value

\S4method{corpusLexDiv}{kRp.corpus}(obj, doc_id = NULL)

\S4method{corpusLexDiv}{kRp.corpus}(obj) <- value

\S4method{corpusFreq}{kRp.corpus}(obj)

\S4method{corpusFreq}{kRp.corpus}(obj) <- value

\S4method{corpusCorpFreq}{kRp.corpus}(obj)

\S4method{corpusCorpFreq}{kRp.corpus}(obj) <- value

corpusHierarchy(obj, ...)

\S4method{corpusHierarchy}{kRp.corpus}(obj)

corpusHierarchy(obj) <- value

\S4method{corpusHierarchy}{kRp.corpus}(obj) <- value

corpusFiles(obj, paths = FALSE, ...)

\S4method{corpusFiles}{kRp.corpus}(obj, paths = FALSE)

corpusFiles(obj) <- value

\S4method{corpusFiles}{kRp.corpus}(obj) <- value

corpusDocTermMatrix(obj, ...)

\S4method{corpusDocTermMatrix}{kRp.corpus}(obj)

corpusDocTermMatrix(obj, terms = NULL, case.sens = NULL, tfidf = NULL) <- value

\S4method{corpusDocTermMatrix}{kRp.corpus}(obj, terms = NULL, case.sens = NULL,
      tfidf = NULL) <- value

\S4method{corpusStopwords}{kRp.corpus}(obj)

\S4method{corpusStopwords}{kRp.corpus}(obj) <- value

\S4method{diffText}{kRp.corpus}(obj, doc_id = NULL)

\S4method{diffText}{kRp.corpus}(obj) <- value

\S4method{originalText}{kRp.corpus}(obj)

is.corpus(obj)

\S4method{[}{kRp.corpus,ANY,ANY,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{kRp.corpus,ANY,ANY,ANY}(x, i, j, ...) <- value

\S4method{[[}{kRp.corpus}(x, i, doc_id = NULL, ...)

\S4method{[[}{kRp.corpus}(x, i, doc_id = NULL, ...) <- value

\S4method{tif_as_tokens_df}{kRp.corpus}(tokens)

tif_as_corpus_df(corpus)

\S4method{tif_as_corpus_df}{kRp.corpus}(corpus)
}
\arguments{
\item{obj}{An object of class \code{\link[tm.plugin.koRpus:kRp.corpus-class]{kRp.corpus}}.}

\item{value}{A new value to replace the current with.}

\item{has_id}{A character vector with \code{doc_id}s to look for in the object. The return value
is then a logical vector of the same length,
      indicating if the respective id was found or not.}

\item{doc_id}{A character vector to limit the scope to one or more particular document IDs.}

\item{simplify}{If \code{TRUE} and result is a list of length 1, return the list element.}

\item{...}{Additional arguments to pass through, depending on the method.}

\item{feature}{Character string naming the object feature to look for.}

\item{meta}{If not NULL, the \code{meta} list entry of the given name.}

\item{fail}{Logical,
      whether the method should fail with an error if \code{meta} was not found.
If set to \code{FALSE}, returns \code{invisible(NULL)} instead.}

\item{paths}{Logical,
      indicates for \code{corpusFiles()} whether full paths should be returned, or just the actual file name.}

\item{terms}{A character string defining the \code{tokens} used for calculating the matrix.
Stored in object's meta data slot.}

\item{case.sens}{Logical, whether terms were counted case sensitive.
Stored in object's meta data slot.}

\item{tfidf}{Logical,
      use \code{TRUE} if the term frequency--inverse document frequency (tf-idf)
values were calculated instead of absolute frequency.
Stored in object's meta data slot.}

\item{x}{See \code{obj}.}

\item{i}{Defines the row selector (\code{[}) or the name to match (\code{[[}) in the tokens slot.}

\item{j}{Defines the column selector in the tokens slot.}

\item{drop}{See \code{\link[base:Extract]{[}}.}

\item{tokens}{An object of class \code{kRp.corpus}.}

\item{corpus}{An object of class \code{kRp.corpus}.}
}
\description{
These methods should be used to get or set values of text objects
generated by functions like \code{\link[tm.plugin.koRpus:readCorpus]{readCorpus}}.
}
\details{
\itemize{
  \item{\code{taggedText()} }{returns the \code{tokens} slot.}
  \item{\code{describe()} }{returns the \code{desc} slot.}
  \item{\code{hasFeature()} }{returns \code{TRUE} or code{FALSE},
      depending on whether the requested feature is present or not.}
  \item{\code{feature()} }{returns the list entry of the \code{feat_list} slot for the requested feature.}
  \item{\code{corpusReadability()} }{returns the list of \code{kRp.readability} objects.}
  \item{\code{corpusTm()} }{returns the \code{VCorpus} object.}
  \item{\code{corpusMeta()} }{returns the list with meta information.}
  \item{\code{corpusHyphen()} }{returns the list of \code{kRp.hyphen} objects.}
  \item{\code{corpusLexDiv()} }{returns the list of \code{kRp.TTR} objects.}
  \item{\code{corpusFiles()} }{returns the character vector of file names of the object.}
  \item{\code{corpusFreq()} }{returns the frequency analysis data from the \code{feat_list} slot.}
  \item{\code{corpusCorpFreq()} }{returns the \code{kRp.corp.freq} object of the \code{feat_list} slot.}
  \item{\code{corpusHierarchy()} }{returns the corpus' hierarchy structure.}
  \item{\code{corpusDocTermMatrix()} }{returns the sparse document term matrix of the \code{feat_list} slot.}
  \item{\code{corpusStopwords()} }{returns the number of stopwords found in each text (if analyzed) from the \code{feat_list} slot.}
  \item{\code{diffText()} }{returns the \code{diff} element of the \code{feat_list} slot.}
  \item{\code{originalText} }{regenerates the original text before text transformations and returns it as a data frame.}
  \item{\code{[}/\code{[[} }{can be used as a shortcut to index the results of \code{taggedText()}.}
  \item{\code{tif_as_corpus_df} }{returns the whole corpus in a single TIF[1] compliant
     data.frame.}
  \item{\code{tif_as_tokens_df} }{returns the \code{tokens} slot in a TIF[1] compliant
     data.frame, i.e., \code{doc_id} is not a factor but a character vector.}
}
}
\examples{
# use readCorpus() to create an object of class kRp.corpus
# code is only run when the english language package can be loaded
if(require("koRpus.lang.en", quietly = TRUE)){
  myCorpus <- readCorpus(
    dir=file.path(
      path.package("tm.plugin.koRpus"), "examples", "corpus", "Winner", "Wikipedia_new"
    ),
    # use tokenize() so examples run without a TreeTagger installation
    tagger="tokenize",
    lang="en"
  )

  taggedText(myCorpus)

  corpusMeta(myCorpus, "note") <- "an interesting read!"

  # export object to TIF compliant data frame
  myCorpus_df <- tif_as_corpus_df(myCorpus)
} else {}
}
\references{
[1] Text Interchange Formats (\url{https://github.com/ropensci/tif})
}
