% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_method_02_kRp.corpus-class_hyphen.R
\docType{methods}
\name{hyphen,kRp.corpus-method}
\alias{hyphen,kRp.corpus-method}
\title{Apply hyphen() to all texts in kRp.corpus objects}
\usage{
\S4method{hyphen}{kRp.corpus}(words, mc.cores = getOption("mc.cores", 1L), quiet = TRUE,
      ...)
}
\arguments{
\item{words}{An object of class \code{\link[tm.plugin.koRpus:kRp.corpus-class]{kRp.corpus}}.}

\item{mc.cores}{The number of cores to use for parallelization,
      see \code{\link[parallel:mclapply]{mclapply}}.}

\item{quiet}{Logical,
      if \code{FALSE} shows a status bar for the hyphenation process of each text.}

\item{...}{options to pass through to \code{\link[sylly:hyphen]{hyphen}}.}
}
\value{
An object of the same class as \code{words}.
}
\description{
This method calls \code{\link[sylly:hyphen]{hyphen}} on all tagged text objects
inside the given \code{words} object (using \code{mclapply}).
}
\examples{
# use readCorpus() to create an object of class kRp.corpus
# code is only run when the english language package can be loaded
if(require("koRpus.lang.en", quietly = TRUE)){
  myCorpus <- readCorpus(
    dir=file.path(
      path.package("tm.plugin.koRpus"), "examples", "corpus", "Winner", "Wikipedia_new"
    ),
    # use tokenize() so examples run without a TreeTagger installation
    tagger="tokenize",
    lang="en"
  )

  myCorpus <- hyphen(myCorpus)
} else {}
}
