% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getExpertWeightSummary.R
\name{getExpertWeightSummary}
\alias{getExpertWeightSummary}
\title{Summarize expert weights}
\usage{
getExpertWeightSummary(expertWeights, n = 1000, weights = NULL)
}
\arguments{
\item{expertWeights}{Expert weights gathered using the roulette method.}

\item{n}{The number of samples to be drawn when summarizing. Default: 1000.}

\item{weights}{Weights assigned to each expert. Defaults to uniform.}
}
\value{
A summary of the expert weights
}
\description{
Compute min, max, mean and quartiles for expert weights
}
\examples{

getExpertWeightSummary(
  rbind(
    c(0, 0, 0, 0, 2, 3, 3, 2, 0, 0), c(0, 0, 0, 2, 3, 3, 2, 0, 0, 0),
    c(0, 1, 2, 4, 2, 1, 0, 0, 0, 0), c(2, 3, 3, 2, 0, 0, 0, 0, 0, 0),
    c(0, 0, 0, 2, 2, 2, 2, 2, 0, 0), c(2, 3, 3, 2, 0, 0, 0, 0, 0, 0)
  )
)

}
\seealso{
\code{\link{drawExpertWeightSample}}
}
