% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tinytest.R
\name{ignore}
\alias{ignore}
\title{Ignore the output of an expectation}
\usage{
ignore(fun)
}
\arguments{
\item{fun}{An \code{expect_} function}
}
\value{
an ignored function
}
\description{
Ignored expectations are not reported in the test results.
Ignoring is only useful for test files, and not for use directly
at the commandline. See also the \href{../docs/using_tinytest.pdf}{vignette}.
}
\examples{
\donttest{
   ## The result of 'expect_warning' is not stored in the test result when
   ## this is run from a file.
   expect_true( ignore(expect_warning)(warning("foo!")) )
   ## Note the placement of the brackets in ignore(expect_warning)(...).
 }


}
\seealso{
Other test-functions: \code{\link{expect_equal}}
}
\concept{test-functions}
