% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tinytest.R
\name{build_install_test}
\alias{build_install_test}
\title{build, install and test}
\usage{
build_install_test(pkgdir = "./", testdir = "tinytest",
  at_home = TRUE, verbose = getOption("tt.verbose", TRUE),
  keep_tempdir = FALSE)
}
\arguments{
\item{pkgdir}{\code{[character]} Package directory}

\item{testdir}{\code{[character]} Name of directory under \code{pkgdir/inst} 
containing test files.}

\item{at_home}{\code{[logical]} toggle local tests.}

\item{verbose}{\code{[logical]} toggle verbosity during execution}

\item{keep_tempdir}{\code{[logical]} keep directory where the pkg is 
installed and where tests are run? If \code{TRUE}, the directory is not deleted 
and it's location is printed.}
}
\value{
A \code{tinytests} object.
}
\description{
Builds and installs the package in \code{pkgdir} under a temporary directory.
Next, loads the package in a fresh R session and runs all the tests. For this
function to work the following system requirements are necessary.
\itemize{
  \item{\code{R CMD build} is available on your system}
  \item{\code{Rscript} is available on your system}
}
}
\examples{
\dontrun{
  ## If your package source directory is "./pkg" you can run
  build_install_test("pkg")
}
}
\seealso{
Other test-files: \code{\link{run_test_dir}},
  \code{\link{run_test_file}},
  \code{\link{summary.tinytests}},
  \code{\link{test_package}}
}
\concept{test-files}
