% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/9_cor_t_choose.R
\name{t_choose}
\alias{t_choose}
\title{t_choose}
\usage{
t_choose(
  genes,
  exp,
  group_list,
  up_only = FALSE,
  down_only = FALSE,
  pvalue_cutoff = 0.05
)
}
\arguments{
\item{genes}{a vector with some genes}

\item{exp}{A numeric matrix}

\item{group_list}{A factor with duplicated character or factor}

\item{up_only}{keep up genes in the result only}

\item{down_only}{keep down genes in the result only}

\item{pvalue_cutoff}{p value cut off ,0.05 by defult}
}
\value{
a vector with differential expressed genes
}
\description{
choose differential expressed genes by simple t.test
}
\examples{
exp = matrix(rnorm(1000),ncol = 10)
rownames(exp) = sample(mRNA_annov23$gene_id,100)
colnames(exp) = c(paste0("TCGA",1:5),paste0("GTEX",1:5))
exp2  = trans_exp(exp)
exp2[,1:5] = exp2[,1:5]+10
group_list = rep(c("A","B"),each = 5)
genes = sample(rownames(exp2),3)
t_choose(genes,exp2,group_list)
}
\author{
Xiaojie Sun
}
