% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5_get_deg_all.R
\name{get_deg_all}
\alias{get_deg_all}
\title{get_deg_all}
\usage{
get_deg_all(
  exp,
  group_list,
  ids,
  symmetry = TRUE,
  my_genes = NULL,
  show_rownames = FALSE,
  cluster_cols = TRUE,
  color_volcano = c("#2874C5", "grey", "#f87669"),
  logFC_cutoff = 1,
  pvalue_cutoff = 0.05,
  adjust = FALSE,
  entriz = TRUE,
  n_cutoff = 2,
  annotation_legend = FALSE,
  lab = NA,
  species = "human"
)
}
\arguments{
\item{exp}{A numeric matrix}

\item{group_list}{A factor with duplicated character or factor}

\item{ids}{a data.frame with 2 columns,including probe_id and symbol}

\item{symmetry}{a logical value ,would you like to get your plot symmetrical}

\item{my_genes}{genes for pheatmap}

\item{show_rownames}{logical,show rownames or not}

\item{cluster_cols}{boolean values determining if columns should be clustered or \code{hclust} object.}

\item{color_volcano}{color for volcano}

\item{logFC_cutoff}{Cutoff value of logFC,1 by default.}

\item{pvalue_cutoff}{Cutoff value of pvalue,0.05 by default.}

\item{adjust}{a logical value, would you like to use adjusted pvalue to draw this plot,FAlSE by default.}

\item{entriz}{logical , if TRUE ,convert symbol to entriz id.}

\item{n_cutoff}{3 by defalut , scale before plot and set a cutoff,usually 2 or 1.6}

\item{annotation_legend}{logical,show annotation legend or not}

\item{lab}{label for  x axis in volcano plot, if NA , x axis names by package}

\item{species}{choose human or mouse, or rat, default: human}
}
\value{
a list with deg data.frame, volcano plot ,pca plot ,heatmap and a list with DEGs.
}
\description{
do diffiencial analysis according to exprission set and group information
}
\examples{
\dontrun{
if(requireNamespace("Biobase",quietly = TRUE)&
   requireNamespace("AnnoProbe",quietly = TRUE)){
  gse = "GSE42872"
  geo = geo_download(gse,destdir=tempdir())
  group_list = rep(c("A","B"),each = 3)
  group_list = factor(group_list)
  find_anno(geo$gpl)
  ids <- AnnoProbe::idmap(geo$gpl,destdir = tempdir())
  dcp = get_deg_all(geo$exp,group_list,ids,entriz = FALSE)
  head(dcp$deg)
  dcp$plots
}else{
  if(!requireNamespace("AnnoProbe",quietly = TRUE)) {
    warning("Package 'AnnoProbe' needed for this function to work.
         Please install it by install.packages('AnnoProbe')",call. = FALSE)
  }
  if(!requireNamespace("Biobase",quietly = TRUE)) {
    warning("Package 'Biobase' needed for this function to work.
         Please install it by BiocManager::install('Biobase')",call. = FALSE)
  }
}
}
}
\seealso{
\code{\link{get_deg}};\code{\link{multi_deg_all}}
}
\author{
Xiaojie Sun
}
