% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5_get_deg_all.R
\name{get_deg_all}
\alias{get_deg_all}
\title{get_deg_all}
\usage{
get_deg_all(
  exp,
  group_list,
  ids,
  pkg = 4,
  my_genes = NULL,
  show_rownames = FALSE,
  entriz = TRUE,
  adjust = FALSE,
  logFC_cutoff = 1,
  pvalue_cutoff = 0.05,
  n_cutoff = 2,
  cluster_cols = TRUE,
  annotation_legend = FALSE,
  lab = NA,
  symmetry = FALSE,
  ...
)
}
\arguments{
\item{exp}{A numeric matrix}

\item{group_list}{A factor with duplicated character or factor}

\item{ids}{a data.frame with 2 columns,including probe_id and symbol}

\item{pkg}{a integer ,means which Differential analysis packages you used,we support three packages by now, 1,2,3,4 respectively means "DESeq2","edgeR","limma(voom)","limma"}

\item{my_genes}{genes for pheatmap}

\item{show_rownames}{logical,show rownames or not}

\item{entriz}{logical , if TRUE ,convert symbol to entriz id.}

\item{adjust}{a logical value, would you like to use adjusted pvalue to draw this plot,FAlSE by default.}

\item{logFC_cutoff}{Cutoff value of logFC,1 by default.}

\item{pvalue_cutoff}{Cutoff value of pvalue,0.05 by default.}

\item{n_cutoff}{3 by defalut , scale before plot and set a cutoff,usually 2 or 1.6}

\item{cluster_cols}{boolean values determining if columns should be clustered or \code{hclust} object.}

\item{annotation_legend}{logical,show annotation legend or not}

\item{lab}{label for  x axis in volcano plot, if NA , x axis names by package}

\item{symmetry}{a logical value ,would you like to get your plot symmetrical}

\item{...}{other parameters from get_deg}
}
\value{
a list with deg data.frame, volcano plot ,pca plot ,heatmap and a list with DEGs.
}
\description{
do diffiencial analysis according to exprission set and group information
}
\examples{
\dontrun{
gse = "GSE42872"
geo = geo_download(gse,destdir=tempdir())
group_list = rep(c("A","B"),each = 3)
group_list = factor(group_list)
find_anno(geo$gpl)
ids <- AnnoProbe::idmap(geo$gpl,destdir = tempdir())
dcp = get_deg_all(geo$exp,group_list,ids)
head(dcp$deg)
dcp$plots
}
}
\seealso{
\code{\link{get_deg}};\code{\link{multi_deg_all}}
}
\author{
Xiaojie Sun
}
