% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_plots.R
\name{draw_KM}
\alias{draw_KM}
\title{draw_KM}
\usage{
draw_KM(
  meta,
  group_list,
  time_col = "time",
  event_col = "event",
  legend.title = "Group",
  legend.labs = levels(group_list),
  color = c("#2874C5", "#f87669", "#e6b707", "#868686", "#92C5DE", "#F4A582",
    "#66C2A5", "#FC8D62", "#8DA0CB", "#E78AC3", "#A6D854", "#FFD92F", "#E5C494",
    "#B3B3B3")
)
}
\arguments{
\item{meta}{survival data with time and event column}

\item{group_list}{A factor with duplicated character or factor}

\item{time_col}{colname of time}

\item{event_col}{colname of event}

\item{legend.title}{legend title}

\item{legend.labs}{character vector specifying legend labels}

\item{color}{color vector}
}
\value{
a KM-plot
}
\description{
draw KM-plot with two or more group
}
\examples{
require("survival")
x = survival::lung
draw_KM(meta = x,
       group_list = x$sex,event_col = "status")
}
\author{
Xiaojie Sun
}
