% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family.R
\name{Families}
\alias{Families}
\alias{delta_lognormal}
\alias{delta_gamma}
\title{Additional families}
\usage{
delta_lognormal(link1, link2 = "log", type = c("standard", "poisson-link"))

delta_gamma(link1, link2 = "log", type = c("standard", "poisson-link"))
}
\arguments{
\item{link1}{Link for first part of delta/hurdle model.}

\item{link2}{Link for second part of delta/hurdle model.}

\item{type}{Delta/hurdle family type. \code{"standard"} for a classic hurdle
model. \code{"poisson-link"} for a Poisson-link delta model (Thorson 2018).}

\item{link}{Link.}
}
\value{
A list with elements common to standard R family objects including \code{family},
\code{link}, \code{linkfun}, and \code{linkinv}. Delta/hurdle model families also have
elements \code{delta} (logical) and \code{type} (standard vs. Poisson-link).
}
\description{
Additional families compatible with \code{\link[=tinyVAST]{tinyVAST()}}.
}
\examples{
delta_lognormal()
delta_gamma()
}
\references{
\emph{Poisson-link delta families}:

Thorson, J.T. 2018. Three problems with the conventional delta-model for
biomass sampling data, and a computationally efficient alternative. Canadian
Journal of Fisheries and Aquatic Sciences, 75(9), 1369-1382.
\doi{10.1139/cjfas-2017-0266}

\emph{Poisson-link delta families}:

Thorson, J.T. 2018. Three problems with the conventional delta-model for
biomass sampling data, and a computationally efficient alternative. Canadian
Journal of Fisheries and Aquatic Sciences, 75(9), 1369-1382.
\doi{10.1139/cjfas-2017-0266}
}
