% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timsr.R
\name{rt_query}
\alias{rt_query}
\title{Get the retention time for each frame.}
\usage{
rt_query(timsr, min_retention_time, max_retention_time, columns = all_columns)
}
\arguments{
\item{timsr}{Instance of TimsR}

\item{min_retention_time}{Lower boundry on retention time.}

\item{max_retention_time}{Upper boundry on retention time.}

\item{columns}{Vector of columns to extract. Defaults to all columns.}
}
\value{
data.frame with selected columns.
}
\description{
Get the retention time for each frame.
}
\examples{
\dontrun{
D = TimsR('path/to/your/folder.d')
print(query_slice(D, 10, 200, 4)) # extract every fourth frame between 10 and 200. 
print(query_slice(D, 10, 200, 4, columns=c('scan','intensity')) # only 'scan' and 'intensity'
}
}
