% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timevis.R
\name{timevis-shiny}
\alias{timevis-shiny}
\alias{timevisOutput}
\alias{renderTimevis}
\title{Shiny bindings for timevis}
\usage{
timevisOutput(outputId, width = "100\%", height = "auto")

renderTimevis(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{output variable to read from}

\item{width, height}{Must be a valid CSS unit (like \code{'100\%'},
\code{'400px'}, \code{'auto'}) or a number, which will be coerced to a
string and have \code{'px'} appended. \code{height} will probably not
have an effect; instead, use the \code{height} parameter in
\code{\link[timevis]{timevis}}.}

\item{expr}{An expression that generates a timevis}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}
}
\description{
Output and render functions for using timevis within Shiny
applications and interactive Rmd documents.
}
\examples{
if (interactive()) {
library(shiny)

#----------------------- Most basic example -----------------
shinyApp(
  ui = fluidPage(timevisOutput("timeline")),
  server = function(input, output) {
    output$timeline <- renderTimevis(
      timevis()
    )
  }
)


#----------------------- More advanced example -----------------
data <- data.frame(
  id = 1:3,
  start = c("2015-04-04", "2015-04-05 11:00:00", "2015-04-06 15:00:00"),
  end = c("2015-04-08", NA, NA),
  content = c("<h2>Vacation!!!</h2>", "Acupuncture", "Massage"),
  style = c("color: red;", NA, NA)
)

ui <- fluidPage(
  timevisOutput("appts"),
  div("Selected items:", textOutput("selected", inline = TRUE)),
  div("Visible window:", textOutput("window", inline = TRUE)),
  tableOutput("table")
)

server <- function(input, output) {
  output$appts <- renderTimevis(
    timevis(
      data,
      options = list(editable = TRUE, multiselect = TRUE, align = "center")
    )
  )

  output$selected <- renderText(
    paste(input$appts_selected, collapse = " ")
  )

  output$window <- renderText(
    paste(input$appts_window[1], "to", input$appts_window[2])
  )

  output$table <- renderTable(
    input$appts_data
  )
}
shinyApp(ui, server)
}

}
\seealso{
\code{\link[timevis]{timevis}}.
}
