% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{removeCustomTime}
\alias{removeCustomTime}
\title{Remove a custom time previously added}
\usage{
removeCustomTime(id, itemId)
}
\arguments{
\item{id}{Timeline id or a \code{timevis} object (the output from \code{timevis()})}

\item{itemId}{The id of the custom time bar}
}
\description{
Remove a custom time previously added
}
\examples{

timevis() \%>\%
  addCustomTime(Sys.Date() - 1, "yesterday") \%>\%
  addCustomTime(Sys.Date() + 1, "tomorrow") \%>\%
  removeCustomTime("yesterday")

if (interactive()) {
library(shiny)
shinyApp(
  ui = fluidPage(
    timevisOutput("timeline"),
    actionButton("btn0", "Add custom time"),
    actionButton("btn", "Remove custom time bar")
  ),
  server = function(input, output) {
    output$timeline <- renderTimevis(
      timevis()
    )
    observeEvent(input$btn0, {
      addCustomTime("timeline", Sys.Date() - 1, "yesterday")
    })
    observeEvent(input$btn, {
      removeCustomTime("timeline", "yesterday")
    })
  }
)
}
}
