% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment-tk_augment_slidify.R
\name{tk_augment_slidify}
\alias{tk_augment_slidify}
\title{Add many rolling window calculations to the data}
\usage{
tk_augment_slidify(
  .data,
  .value,
  .period,
  .f,
  ...,
  .align = c("center", "left", "right"),
  .partial = FALSE,
  .names = "auto"
)
}
\arguments{
\item{.data}{A tibble.}

\item{.value}{One or more column(s) to have a transformation applied. Usage
of \code{tidyselect} functions (e.g. \code{contains()}) can be used to select multiple columns.}

\item{.period}{One or more periods for the rolling window(s)}

\item{.f}{A summary \verb{[function / formula]},}

\item{...}{Optional arguments for the summary function}

\item{.align}{Rolling functions generate \code{.period - 1} fewer values than the incoming vector.
Thus, the vector needs to be aligned. Select one of "center", "left", or "right".}

\item{.partial}{.partial Should the moving window be allowed to return partial (incomplete) windows instead of \code{NA} values.
Set to FALSE by default, but can be switched to TRUE to remove \code{NA}'s.}

\item{.names}{A vector of names for the new columns. Must be of same length as \code{.period}. Default is "auto".}
}
\value{
Returns a \code{tibble} object describing the timeseries.
}
\description{
Quickly use any function as a rolling function and apply to multiple \code{.periods}.
Works with \code{dplyr} groups too.
}
\details{
\code{tk_augment_slidify()} scales the \code{\link[=slidify_vec]{slidify_vec()}} function to multiple
time series \code{.periods}. See \code{\link[=slidify_vec]{slidify_vec()}} for examples and usage of the core function
arguments.
}
\examples{
library(dplyr)
library(stringr)
library(timetk)

# Single Column | Multiple Rolling Windows
FANG \%>\%
    select(symbol, date, adjusted) \%>\%
    group_by(symbol) \%>\%
    tk_augment_slidify(
        .value   = contains("adjust"),
        # Multiple rolling windows
        .period  = c(10, 30, 60, 90),
        .f       = mean,
        .partial = TRUE,
        .names   = str_c("MA_", c(10, 30, 60, 90))
    ) \%>\%
    ungroup()

# Multiple Columns | Multiple Rolling Windows
FANG \%>\%
    select(symbol, date, adjusted, volume) \%>\%
    group_by(symbol) \%>\%
    tk_augment_slidify(
        .value  = c(adjusted, volume),
        .period  = c(10, 30, 60, 90),
        .f       = mean,
        .partial = TRUE
    ) \%>\%
    ungroup()

}
\seealso{
Augment Operations:
\itemize{
\item \code{\link[=tk_augment_timeseries_signature]{tk_augment_timeseries_signature()}} - Group-wise augmentation of timestamp features
\item \code{\link[=tk_augment_holiday_signature]{tk_augment_holiday_signature()}} - Group-wise augmentation of holiday features
\item \code{\link[=tk_augment_slidify]{tk_augment_slidify()}} - Group-wise augmentation of rolling functions
\item \code{\link[=tk_augment_lags]{tk_augment_lags()}} - Group-wise augmentation of lagged data
\item \code{\link[=tk_augment_differences]{tk_augment_differences()}} - Group-wise augmentation of differenced data
\item \code{\link[=tk_augment_fourier]{tk_augment_fourier()}} - Group-wise augmentation of fourier series
}

Underlying Function:
\itemize{
\item \code{\link[=slidify_vec]{slidify_vec()}} - The underlying function that powers \code{tk_augment_slidify()}
}
}
