% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-anomaly_diagnostics.R
\name{plot_anomaly_diagnostics}
\alias{plot_anomaly_diagnostics}
\title{Visualize Anomalies for One or More Time Series}
\usage{
plot_anomaly_diagnostics(
  .data,
  .date_var,
  .value,
  .facet_vars = NULL,
  .frequency = "auto",
  .trend = "auto",
  .alpha = 0.05,
  .max_anomalies = 0.2,
  .message = TRUE,
  .facet_ncol = 1,
  .facet_nrow = 1,
  .facet_scales = "free",
  .facet_dir = "h",
  .facet_collapse = FALSE,
  .facet_collapse_sep = " ",
  .facet_strip_remove = FALSE,
  .line_color = "#2c3e50",
  .line_size = 0.5,
  .line_type = 1,
  .line_alpha = 1,
  .anom_color = "#e31a1c",
  .anom_alpha = 1,
  .anom_size = 1.5,
  .ribbon_fill = "grey20",
  .ribbon_alpha = 0.2,
  .legend_show = TRUE,
  .title = "Anomaly Diagnostics",
  .x_lab = "",
  .y_lab = "",
  .color_lab = "Anomaly",
  .interactive = TRUE,
  .trelliscope = FALSE,
  .trelliscope_params = list()
)
}
\arguments{
\item{.data}{A \code{tibble} or \code{data.frame} with a time-based column}

\item{.date_var}{A column containing either date or date-time values}

\item{.value}{A column containing numeric values}

\item{.facet_vars}{One or more grouping columns that broken out into \code{ggplot2} facets.
These can be selected using \code{tidyselect()} helpers (e.g \code{contains()}).}

\item{.frequency}{Controls the seasonal adjustment (removal of seasonality).
Input can be either "auto", a time-based definition (e.g. "2 weeks"),
or a numeric number of observations per frequency (e.g. 10).
Refer to \code{\link[=tk_get_frequency]{tk_get_frequency()}}.}

\item{.trend}{Controls the trend component.
For STL, trend controls the sensitivity of the LOESS smoother, which is used to remove the remainder.
Refer to \code{\link[=tk_get_trend]{tk_get_trend()}}.}

\item{.alpha}{Controls the width of the "normal" range. Lower values are more conservative
while higher values are less prone to incorrectly classifying "normal" observations.}

\item{.max_anomalies}{The maximum percent of anomalies permitted to be identified.}

\item{.message}{A boolean. If \code{TRUE}, will output information related to automatic frequency
and trend selection (if applicable).}

\item{.facet_ncol}{Number of facet columns.}

\item{.facet_nrow}{Number of facet rows (only used for \code{.trelliscope = TRUE})}

\item{.facet_scales}{Control facet x & y-axis ranges. Options include "fixed", "free", "free_y", "free_x"}

\item{.facet_dir}{The direction of faceting ("h" for horizontal, "v" for vertical). Default is "h".}

\item{.facet_collapse}{Multiple facets included on one facet strip instead of
multiple facet strips.}

\item{.facet_collapse_sep}{The separator used for collapsing facets.}

\item{.facet_strip_remove}{Whether or not to remove the strip and text label for each facet.}

\item{.line_color}{Line color.}

\item{.line_size}{Line size.}

\item{.line_type}{Line type.}

\item{.line_alpha}{Line alpha (opacity). Range: (0, 1).}

\item{.anom_color}{Color for the anomaly dots}

\item{.anom_alpha}{Opacity for the anomaly dots. Range: (0, 1).}

\item{.anom_size}{Size for the anomaly dots}

\item{.ribbon_fill}{Fill color for the acceptable range}

\item{.ribbon_alpha}{Fill opacity for the acceptable range. Range: (0, 1).}

\item{.legend_show}{Toggles on/off the Legend}

\item{.title}{Plot title.}

\item{.x_lab}{Plot x-axis label}

\item{.y_lab}{Plot y-axis label}

\item{.color_lab}{Plot label for the color legend}

\item{.interactive}{If TRUE, returns a \code{plotly} interactive plot.
If FALSE, returns a static \code{ggplot2} plot.}

\item{.trelliscope}{Returns either a normal plot or a trelliscopejs plot (great for many time series)
Must have \code{trelliscopejs} installed.}

\item{.trelliscope_params}{Pass parameters to the \code{trelliscopejs::facet_trelliscope()} function as a \code{list()}.
The only parameters that cannot be passed are:
\itemize{
\item \code{ncol}: use \code{.facet_ncol}
\item \code{nrow}: use \code{.facet_nrow}
\item \code{scales}: use \code{facet_scales}
\item \code{as_plotly}: use \code{.interactive}
}}
}
\value{
A \code{plotly} or \code{ggplot2} visualization
}
\description{
An interactive and scalable function for visualizing anomalies in time series data.
Plots are available in interactive \code{plotly} (default) and static \code{ggplot2} format.
}
\details{
The \code{plot_anomaly_diagnostics()} is a visualization wrapper for \code{tk_anomaly_diagnostics()}
group-wise anomaly detection, implements a 2-step process to
detect outliers in time series.

\strong{Step 1: Detrend & Remove Seasonality using STL Decomposition}

The decomposition separates the "season" and "trend" components from the "observed" values
leaving the "remainder" for anomaly detection.

The user can control two parameters: frequency and trend.
\enumerate{
\item \code{.frequency}: Adjusts the "season" component that is removed from the "observed" values.
\item \code{.trend}: Adjusts the trend window (t.window parameter from \code{\link[stats:stl]{stats::stl()}} that is used.
}

The user may supply both \code{.frequency} and \code{.trend} as time-based durations (e.g. "6 weeks") or
numeric values (e.g. 180) or "auto", which predetermines the frequency and/or trend based on
the scale of the time series using the \code{\link[=tk_time_scale_template]{tk_time_scale_template()}}.

\strong{Step 2: Anomaly Detection}

Once "trend" and "season" (seasonality) is removed, anomaly detection is performed on the "remainder".
Anomalies are identified, and boundaries (recomposed_l1 and recomposed_l2) are determined.

The Anomaly Detection Method uses an inner quartile range (IQR) of +/-25 the median.

\emph{IQR Adjustment, alpha parameter}

With the default \code{alpha = 0.05}, the limits are established by expanding
the 25/75 baseline by an IQR Factor of 3 (3X).
The \emph{IQR Factor = 0.15 / alpha} (hence 3X with alpha = 0.05):
\itemize{
\item To increase the IQR Factor controlling the limits, decrease the alpha,
which makes it more difficult to be an outlier.
\item Increase alpha to make it easier to be an outlier.
\item The IQR outlier detection method is used in \code{forecast::tsoutliers()}.
\item A similar outlier detection method is used by Twitter's \code{AnomalyDetection} package.
\item Both Twitter and Forecast tsoutliers methods have been implemented in Business Science's \code{anomalize}
package.
}
}
\examples{
library(tidyverse)
library(timetk)

walmart_sales_weekly \%>\%
    group_by(id) \%>\%
    plot_anomaly_diagnostics(Date, Weekly_Sales,
                             .message = FALSE,
                             .facet_ncol = 3,
                             .ribbon_alpha = 0.25,
                             .interactive = FALSE)



}
\references{
\enumerate{
\item CLEVELAND, R. B., CLEVELAND, W. S., MCRAE, J. E., AND TERPENNING, I.
STL: A Seasonal-Trend Decomposition Procedure Based on Loess.
Journal of Official Statistics, Vol. 6, No. 1 (1990), pp. 3-73.
\item Owen S. Vallis, Jordan Hochenbaum and Arun Kejariwal (2014).
A Novel Technique for Long-Term Anomaly Detection in the Cloud. Twitter Inc.
}
}
\seealso{
\itemize{
\item \code{\link[=tk_anomaly_diagnostics]{tk_anomaly_diagnostics()}}: Group-wise anomaly detection
}
}
