\name{randomizetimes}
\alias{randomizetimes}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Resamples data based on event time.
}
\description{
Produces a new event list from an existing event list with resampled event times given certain constraints on randomization. Effectively re-orders pairs of start/stop times between different vertices.
}
\usage{
randomizetimes(raw, withinvertexfrom, byvertexfrom, withreplacement)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{raw}{
A raw event list to be resampled. Contains four columns: VertexFrom, VertexTo, TimeStart, TimeStop
}
  \item{withinvertexfrom}{
If true, resamples within data subsets where VertexFrom is fixed; otherwise resamples within all data.
}
  \item{byvertexfrom}{
If true, subsets of data for withinvertexfrom are obtained using VertexFrom; if false, using VertexTo.
}
  \item{withreplacement}{
Samples with or without replacement.
}
}
\details{
%%  ~~ If necessary, more details than the description above ~~
}
\value{
An event list of the same size as raw with event times resampled. Resampling does not break the relationship between start and stop time; i.e. resampled events will have the same duration as original events.
}
\references{
%% ~put references to the literature/web site here ~
}
\author{Benjamin Blonder \email{bblonder@email.arizona.edu}.}
\note{
%%  ~~further notes~~
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{randomizeidentities}},\code{\link{rarefy}}
}
\examples{
data(ants)
allindivs <- c(union(ants$VertexFrom, ants$VertexTo), "NULL1", "NULL2")
rt <- randomizetimes(ants,withinvertexfrom=TRUE,byvertexfrom=TRUE,withreplacement=TRUE)
g <- generatetonetwork(rt, allindivs)
plottonet(g)

## The function is currently defined as
function(raw, withinvertexfrom, byvertexfrom, withreplacement=TRUE)
{
	if (byvertexfrom)
	{
		if (withinvertexfrom)
		{
			list<-by(raw,raw$VertexFrom, function(x) { newtimeorder <- sample(nrow(x), replace=withreplacement); x$TimeStart <- x$TimeStart[newtimeorder]; x$TimeStop <- x$TimeStop[newtimeorder]; return(x)})
			outdf <- do.call(rbind.fill, list)	
		}
		else
		{
			newtimeorder <- sample(nrow(raw),replace=withreplacement)
			outdf <- raw
			outdf$TimeStart <- outdf$TimeStart[newtimeorder]
			outdf$TimeStop <- outdf$TimeStop[newtimeorder]
		}
	}
	else
	{
		if (withinvertexfrom)
		{
			list<-by(raw,raw$VertexTo, function(x) { newtimeorder <- sample(nrow(x), replace=withreplacement); x$TimeStart <- x$TimeStart[newtimeorder]; x$TimeStop <- x$TimeStop[newtimeorder]; return(x)})
			outdf <- do.call(rbind.fill, list)	
		}
		else
		{
			newtimeorder <- sample(nrow(raw), replace=withreplacement)
			outdf <- raw
			outdf$TimeStart <- outdf$TimeStart[newtimeorder]
			outdf$TimeStop <- outdf$TimeStop[newtimeorder]
		}
		
	}
	return(outdf)
}


}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
