% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/states.R
\name{states}
\alias{states}
\title{Download shapefile for all states into R}
\usage{
states(cb = FALSE, resolution = "500k", year = NULL, ...)
}
\arguments{
\item{cb}{If cb is set to TRUE, download a generalized (1:500k)
states file.  Defaults to FALSE (the most detailed TIGER/Line file)}

\item{resolution}{The resolution of the cartographic boundary file (if cb == TRUE).
Defaults to '500k'; options include '5m' (1:5 million) and '20m' (1:20 million).}

\item{year}{the year of the data download (defaults to 2020)}

\item{...}{arguments to be passed to the underlying `load_tiger` function, which is not exported.
Options include \code{class}, which can be set to \code{"sf"} (the default) or \code{"sp"} to
request sf or sp class objects, and \code{refresh}, which specifies whether or
not to re-download shapefiles (defaults to \code{FALSE}).}
}
\description{
States and Equivalent Entities are the primary governmental divisions of the
United States.  In addition to the 50 states, the Census Bureau treats the
District of Columbia, Puerto Rico, American Samoa, the Commonwealth of the
Northern Mariana Islands, Guam, and the U.S. Virgin Islands as the statistical
equivalents of states for the purpose of data presentation.
}
\examples{
\dontrun{
library(tigris)
library(leaflet)

states <- states(cb = TRUE)

leaflet(states) \%>\%
  addProviderTiles("CartoDB.Positron") \%>\%
  addPolygons(fillColor = "white",
              color = "black",
              weight = 0.5) \%>\%
  setView(-98.5795, 39.8282, zoom=3)
}
}
\seealso{
\url{https://www2.census.gov/geo/pdfs/reference/GARM/Ch4GARM.pdf}

Other general area functions: 
\code{\link{block_groups}()},
\code{\link{blocks}()},
\code{\link{counties}()},
\code{\link{county_subdivisions}()},
\code{\link{places}()},
\code{\link{pumas}()},
\code{\link{school_districts}()},
\code{\link{tracts}()},
\code{\link{zctas}()}
}
\concept{general area functions}
