% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enumeration_units.R
\name{zctas}
\alias{zctas}
\title{Download a Zip Code Tabulation Area (ZCTA) shapefile into R}
\usage{
zctas(cb = FALSE, starts_with = NULL, year = NULL, state = NULL,
  ...)
}
\arguments{
\item{cb}{If cb is set to TRUE, download a generalized (1:500k)
ZCTA file.  Defaults to FALSE (the most detailed TIGER/Line file).
\strong{A warning:} the detailed TIGER/Line ZCTA file is massive
(around 502MB unzipped), and the generalized version is also large
(64MB zipped).  Be prepared for this especially if you have a slower
internet connection.}

\item{starts_with}{Character vector specifying the beginning digits of the
ZCTAs you want to return.  For example, supplying the argument
\code{starts_with = c("75", "76")} will return only those ZCTAs that begin
with 75 or 76.  Defaults to NULL, which will return all ZCTAs in the US.}

\item{year}{the data year (defaults to 2017).}

\item{state}{the state for which you are requesting data; only available for 2000 and 2010}

\item{...}{arguments to be passed to the underlying `load_tiger` function, which is not exported.
Options include \code{class}, which can be set to \code{"sp"} (the default) or \code{"sf"} to
request sp or sf class objects, and \code{refresh}, which specifies whether or
not to re-download shapefiles (defaults to \code{FALSE}).}
}
\description{
ZIP Code Tabulation Areas (ZCTAs) are generalized areal representations of
United States Postal Service (USPS) ZIP Code service areas.  Please see the link provided for
information on how the Census Bureau creates ZCTAs, and for important information on the
differences between ZCTAs and ZIP Codes.
}
\examples{
\dontrun{
# Example: get ZCTAs that intersect the Memphis, TN urbanized area

library(tigris)
library(rgeos)
library(sp)

df <- zctas(cb = TRUE, starts_with = c("37", "38", "72"))

uas <- urban_areas()

memphis_ua <- uas[grep("Memphis", uas$NAME10), ]

mem_zcta <- df[as.vector(gIntersects(df, memphis_ua, byid = TRUE)), ]

plot(mem_zcta)

}
}
\seealso{
\url{https://www.census.gov/geo/reference/zctas.html}

Other general area functions: \code{\link{block_groups}},
  \code{\link{blocks}}, \code{\link{counties}},
  \code{\link{county_subdivisions}}, \code{\link{places}},
  \code{\link{pumas}}, \code{\link{school_districts}},
  \code{\link{states}}, \code{\link{tracts}}
}
\concept{general area functions}
