% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{reassignAlleles}
\alias{reassignAlleles}
\title{Correct allele calls based on a personalized genotype}
\usage{
reassignAlleles(clip_db, genotype_db, v_call = "V_CALL", method = "hamming",
  path = NA, keep_gene = TRUE)
}
\arguments{
\item{clip_db}{a \code{data.frame} containing V allele calls from a
single subject and the sample
IMGT-gapped V(D)J sequences under
\code{"SEQUENCE_IMGT"}}

\item{genotype_db}{a vector of named nucleotide germline sequences
matching the calls detailed in \code{allele_calls}
and personalized to the subject}

\item{v_call}{name of the column in \code{clip_db} with V allele
calls. Default is \code{"V_CALL"}}

\item{method}{the method to be used when realigning sequences to
the genotype_db sequences. Currently only "hammming"
(for Hamming distance) is implemented.}

\item{path}{directory containing the tool used in the
realignment method, if needed. Hamming distance does
not require a path to a tool.}

\item{keep_gene}{logical indicating if gene assignments should be
maintained when possible. Increases speed by
minimizing required number of alignments. Currently
only "TRUE" is implemented.}
}
\value{
a single-column \code{data.frame} corresponding to \code{clip.db}
          and containing the best allele call from among the sequences
          listed in \code{genotype_db}
}
\description{
\code{reassignAlleles} uses a subject-specific genotype to correct
correct preliminary allele assignments of a set of sequences derived
from a single subject.
}
\details{
In order to save time, initial gene assignments are preserved and
the allele calls are chosen from among those provided in \code{genotype_db},
based on a simple alignment to the sample sequence.
}
\examples{
# Load example data
data(germline_ighv)
data(sample_db)
data(genotype)
data(novel_df)
                     
# Extract the database sequences that correspond to the genotype
genotype_seqs = genotypeFasta(genotype, germline_ighv, novel_df)

# Use the personlized genotype to determine corrected allele assignments
V_CALL_GENOTYPED = reassignAlleles(sample_db, genotype_seqs)
sample_db = cbind(sample_db, V_CALL_GENOTYPED)

}
