% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-like.R
\name{count_by}
\alias{count_by}
\title{Count according to grouping}
\usage{
count_by(
  .tbl,
  ...,
  column_names = c("n", "rel", "percent"),
  percentage_label_decimal_places = 1,
  add_grouping = T,
  na.rm = F
)
}
\arguments{
\item{.tbl}{A data frame}

\item{...}{Columns / expressions by which to group / which shall be used for counting.}

\item{column_names}{vector if size 1 to 3, giving the names of (in order if unnamed, or named with n, rel, percent)
the column containing the count, the relative proportion, and the latter formatted as a percent label.
If a name is not contained, it will not be added (requires named vector).}

\item{percentage_label_decimal_places}{Decimal precision of the percent label}

\item{add_grouping}{Shall a pre-existing grouping be preserved for counting (adding the newly specified grouping)?
Default is yes, which differs from group_by.}

\item{na.rm}{Shall NA values be removed prior to counting?}
}
\value{
The counted data frame
}
\description{
Similar to \code{\link[dplyr]{count}()}, but also adds the relative proportion and
a percent-formatted string of the relative proportion,
and allows to specify the column names.
}
\examples{
library(magrittr)
if (requireNamespace("survival", quietly = TRUE))
{
   survival::aml \%>\%
   count_by(x)
}
}
