% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_spatrasters.R
\name{compare_spatrasters}
\alias{compare_spatrasters}
\title{Compare attributes of two SpatRasters}
\usage{
compare_spatrasters(x, y, digits = 6)
}
\arguments{
\item{x, y}{SpatRaster objects}

\item{digits}{Integer to set the precision for comparing the extent and
the resolution.}
}
\value{
A invisible logical \code{TRUE/FALSE} indicating if the SpatRasters are
compatible, plus an informative message flagging the issues found (if any).
}
\description{
Two SpatRasters are compatible (in terms of combining layers) if the
crs, extent and resolution are similar. In those cases you can combine
the SpatRasters simply as \code{c(x, y)}.

This function compares those attributes informing of the results. See
\strong{Solving issues} section for minimal guidance.
}
\section{Solving issues}{


On \strong{non-equal crs}, try \code{\link[terra:project]{terra::project()}}. On \strong{non-equal extent} try
\code{\link[terra:resample]{terra::resample()}}. On \strong{non-equal resolution} you can try
\code{\link[terra:resample]{terra::resample()}}, \code{\link[terra:aggregate]{terra::aggregate()}} or \code{\link[terra:disaggregate]{terra::disagg()}}.
}

\examples{
library(terra)

x <- rast(matrix(1:90, ncol = 3), crs = "epsg:3857")

# Nothing
compare_spatrasters(x, x)

# Different crs
y_nocrs <- x
crs(y_nocrs) <- NA

compare_spatrasters(x, y_nocrs)

# Different extent
compare_spatrasters(x, x[1:10, , drop = FALSE])

# Different resolution
y_newres <- x

res(y_newres) <- res(x) / 2
compare_spatrasters(x, y_newres)

# Everything

compare_spatrasters(x, project(x, "epsg:3035"))
}
\seealso{
Other helpers: 
\code{\link{is_regular_grid}()},
\code{\link{pull_crs}()}
}
\concept{helpers}
